/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.openl.CompiledOpenClass;
import org.openl.exception.OpenLException;
import org.openl.main.SourceCodeURLTool;
import org.openl.message.OpenLErrorMessage;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.message.OpenLWarnMessage;
import org.openl.message.Severity;
import org.openl.rules.table.xls.XlsUrlParser;
import org.openl.rules.ui.ProjectModel;
import org.openl.rules.ui.WebStudio;
import org.openl.rules.ui.tree.TreeNodeData;
import org.openl.rules.webstudio.web.util.WebStudioUtils;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.util.StringTool;
import org.openl.util.text.ILocation;
import org.richfaces.model.TreeNode;
import org.richfaces.model.TreeNodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemsBean {
    public static final String ERRORS_ROOT_NAME = "Errors";
    public static final String WARNINGS_ROOT_NAME = "Warnings";
    public static final String ERROR_NODE_NAME = "error";
    public static final String WARNING_NODE_NAME = "warning";

    public TreeNode<?> getTree() {
        int nodeCount = 1;
        WebStudio studio = WebStudioUtils.getWebStudio();
        if (studio.getCurrentProject() != null) {
            List warningMessages;
            ProjectModel model = studio.getModel();
            CompiledOpenClass compiledOpenClass = model.getCompiledOpenClass();
            List messages = compiledOpenClass.getMessages();
            TreeNodeImpl root = new TreeNodeImpl();
            List errorMessages = OpenLMessagesUtils.filterMessagesBySeverity((List)messages, (Severity)Severity.ERROR);
            if (CollectionUtils.isNotEmpty((Collection)errorMessages)) {
                TreeNode<TreeNodeData> errorsRoot = this.createMessagesRoot(ERRORS_ROOT_NAME, errorMessages.size());
                this.addMessageNodes(errorsRoot, ERROR_NODE_NAME, errorMessages);
                root.addChild((Object)nodeCount++, errorsRoot);
            }
            if (CollectionUtils.isNotEmpty((Collection)(warningMessages = OpenLMessagesUtils.filterMessagesBySeverity((List)messages, (Severity)Severity.WARN)))) {
                TreeNode<TreeNodeData> warningsRoot = this.createMessagesRoot(WARNINGS_ROOT_NAME, warningMessages.size());
                this.addMessageNodes(warningsRoot, WARNING_NODE_NAME, warningMessages);
                root.addChild((Object)nodeCount++, warningsRoot);
            }
            return root;
        }
        return null;
    }

    private TreeNode<TreeNodeData> createMessagesRoot(String rootName, int messagesNumber) {
        TreeNodeImpl messagesRoot = new TreeNodeImpl();
        TreeNodeData nodeData = new TreeNodeData(rootName + " [" + messagesNumber + "]", rootName, null, 0, rootName.toLowerCase(), true);
        messagesRoot.setData((Object)nodeData);
        return messagesRoot;
    }

    private void addMessageNodes(TreeNode<TreeNodeData> parent, String nodeName, List<OpenLMessage> messages) {
        int nodeCount = 1;
        for (OpenLMessage message : messages) {
            TreeNodeImpl messageNode = new TreeNodeImpl();
            String url = this.getNodeUrl(message);
            TreeNodeData nodeData = new TreeNodeData(message.getSummary(), message.getDetails(), url, 0, nodeName.toLowerCase(), true);
            messageNode.setData((Object)nodeData);
            parent.addChild((Object)nodeCount++, (TreeNode)messageNode);
        }
    }

    private String getNodeUrl(OpenLMessage message) {
        OpenLWarnMessage warnMessage;
        ISyntaxNode syntaxNode;
        XlsUrlParser uriParser;
        OpenLErrorMessage errorMessage;
        OpenLException error;
        String errorUri;
        String tableUri;
        String url = null;
        if (message instanceof OpenLErrorMessage && StringUtils.isNotBlank((String)(tableUri = (errorUri = SourceCodeURLTool.makeSourceLocationURL((ILocation)(error = (errorMessage = (OpenLErrorMessage)message).getError()).getLocation(), (IOpenSourceCodeModule)error.getSourceModule(), (String)""))))) {
            uriParser = new XlsUrlParser();
            uriParser.parse(errorUri);
            url = "tableeditor/showTable.xhtml?uri=" + StringTool.encodeURL((String)tableUri);
            if (StringUtils.isNotBlank((String)uriParser.cell)) {
                url = url + "&errorCell=" + uriParser.cell;
            }
        }
        if (message instanceof OpenLWarnMessage && StringUtils.isNotBlank((String)(tableUri = (errorUri = SourceCodeURLTool.makeSourceLocationURL((ILocation)(syntaxNode = (warnMessage = (OpenLWarnMessage)message).getSource()).getSourceLocation(), (IOpenSourceCodeModule)syntaxNode.getModule(), (String)""))))) {
            uriParser = new XlsUrlParser();
            uriParser.parse(errorUri);
            url = "tableeditor/showTable.xhtml?uri=" + StringTool.encodeURL((String)tableUri);
            if (StringUtils.isNotBlank((String)uriParser.cell)) {
                url = url + "&errorCell=" + uriParser.cell;
            }
        }
        if (StringUtils.isBlank(url)) {
            url = "tableeditor/showMessage.xhtml?type=" + message.getSeverity().name() + "&summary" + "=" + StringTool.encodeURL((String)message.getSummary());
        }
        return url;
    }
}

