/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web;

import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.rules.ui.WebStudio;
import org.openl.rules.ui.tests.results.RanTestsResults;
import org.openl.rules.ui.tree.richfaces.ProjectTreeBuilder;
import org.openl.rules.ui.tree.richfaces.TreeStateManager;
import org.openl.rules.ui.view.WebStudioViewMode;
import org.openl.rules.webstudio.web.util.WebStudioUtils;
import org.openl.rules.workspace.uw.UserWorkspaceProject;
import org.openl.util.tree.ITreeElement;
import org.richfaces.model.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeBean {
    private TreeStateManager stateManager;

    public TreeBean() {
        String nodeToOpen = FacesUtils.getRequestParameter((String)"nodeToOpen");
        this.stateManager = new TreeStateManager(nodeToOpen);
    }

    public TreeStateManager getStateManager() {
        return this.stateManager;
    }

    public String getCurrentSubMode() {
        WebStudio studio = WebStudioUtils.getWebStudio();
        String mode = studio.getMode().getName();
        return mode;
    }

    public void setCurrentSubMode(String currentSubMode) throws Exception {
        WebStudio studio = WebStudioUtils.getWebStudio();
        studio.setMode(currentSubMode);
    }

    public List<SelectItem> getSubModes() {
        WebStudioViewMode mode;
        String modeType;
        ArrayList<SelectItem> subModes = new ArrayList<SelectItem>();
        WebStudio studio = WebStudioUtils.getWebStudio();
        WebStudioViewMode[] modes = studio.getViewSubModes(modeType = (String)(mode = studio.getMode()).getType());
        if (modes != null) {
            for (WebStudioViewMode viewMode : modes) {
                subModes.add(new SelectItem((Object)viewMode.getName(), viewMode.getDisplayName(1)));
            }
        }
        return subModes;
    }

    public boolean isProjectExists() {
        WebStudio studio = WebStudioUtils.getWebStudio();
        UserWorkspaceProject currentProject = studio.getCurrentProject();
        return currentProject != null;
    }

    public boolean isProjectCheckedOut() {
        WebStudio studio = WebStudioUtils.getWebStudio();
        UserWorkspaceProject currentProject = studio.getCurrentProject();
        return currentProject.isCheckedOut();
    }

    public boolean isProjectLocalOnly() {
        WebStudio studio = WebStudioUtils.getWebStudio();
        UserWorkspaceProject currentProject = studio.getCurrentProject();
        return currentProject.isLocalOnly();
    }

    public boolean isProjectLocked() {
        WebStudio studio = WebStudioUtils.getWebStudio();
        UserWorkspaceProject currentProject = studio.getCurrentProject();
        return currentProject.isLocked();
    }

    public boolean isProjectHasTests() {
        WebStudio studio = WebStudioUtils.getWebStudio();
        RanTestsResults allTestMethods = studio.getModel().getAllTestMethods();
        if (allTestMethods != null) {
            return allTestMethods.getTests().length > 0;
        }
        return false;
    }

    public TreeNode<?> getTree() {
        WebStudio studio = WebStudioUtils.getWebStudio();
        ITreeElement<?> tree = studio.getModel().getProjectTree();
        if (tree != null) {
            TreeNode<?> rfTree = new ProjectTreeBuilder(tree, studio.getModel()).build();
            return rfTree;
        }
        return null;
    }
}

