/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.diff;

import java.util.ArrayList;
import java.util.List;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.rules.diff.hierarchy.Projection;
import org.openl.rules.diff.hierarchy.ProjectionProperty;
import org.openl.rules.diff.tree.DiffElement;
import org.openl.rules.diff.tree.DiffTreeNode;
import org.openl.rules.diff.util.DiffHelper;
import org.openl.rules.diff.xls.XlsProjectionType;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IOpenLTable;
import org.openl.rules.table.ui.IGridSelector;
import org.openl.rules.table.ui.RegionGridSelector;
import org.openl.rules.table.ui.filters.ColorGridFilter;
import org.openl.rules.table.ui.filters.IGridFilter;
import org.openl.rules.webstudio.web.util.WebStudioUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDiffController {
    private String currentNodeId;
    private DiffTreeNode diffTree;
    private boolean showEqualElements = false;

    public abstract String compare();

    public DiffTreeNode[] getDiffTreeNodes() {
        DiffTreeNode tree = DiffHelper.getDiffNodeById((DiffTreeNode)this.getDiffTree(), (String)this.getCurrentNodeId());
        if (tree != null) {
            return tree.getChildren();
        }
        return new DiffTreeNode[0];
    }

    public String getCurrentNodeId() {
        this.currentNodeId = FacesUtils.getRequestParameter((String)"id");
        return this.currentNodeId;
    }

    public void setCurrentNodeId(String currentNodeId) {
        this.currentNodeId = currentNodeId;
    }

    public boolean isShowEqualElements() {
        return this.showEqualElements;
    }

    public void setShowEqualElements(boolean showEqualElements) {
        this.showEqualElements = showEqualElements;
    }

    public IOpenLTable getTable1() {
        return this.getTable(0);
    }

    public IOpenLTable getTable2() {
        return this.getTable(1);
    }

    public IOpenLTable getTable(int i) {
        String projType;
        Projection projection;
        DiffElement[] elems;
        DiffTreeNode tree = DiffHelper.getDiffNodeById((DiffTreeNode)this.getDiffTree(), (String)this.getCurrentNodeId());
        if (tree != null && (elems = tree.getElements()).length > i && (projection = elems[i].getProjection()) != null && (projType = projection.getType()).equalsIgnoreCase(XlsProjectionType.TABLE.name())) {
            ProjectionProperty[] props = projection.getProperties();
            return (IOpenLTable)DiffHelper.getPropValue((ProjectionProperty[])props, (String)"grid");
        }
        return null;
    }

    public IGridFilter getFilter2() {
        return this.getFilter(1);
    }

    public IGridFilter getFilter(int i) {
        String projType;
        Projection projection;
        DiffElement[] elems;
        DiffTreeNode tree = DiffHelper.getDiffNodeById((DiffTreeNode)this.getDiffTree(), (String)this.getCurrentNodeId());
        if (tree != null && (elems = tree.getElements()).length > i && (projection = elems[i].getProjection()) != null && (projType = projection.getType()).equalsIgnoreCase(XlsProjectionType.TABLE.name())) {
            ProjectionProperty[] props = projection.getProperties();
            IOpenLTable table = (IOpenLTable)DiffHelper.getPropValue((ProjectionProperty[])props, (String)"grid");
            List cells = DiffHelper.getDiffNodesByType((DiffTreeNode)tree, (String)XlsProjectionType.CELL.name());
            ArrayList<ICell> diffCells = new ArrayList<ICell>();
            for (DiffTreeNode cellNode : cells) {
                DiffElement cellElem = cellNode.getElements()[i];
                if (cellElem.isSelfEqual()) continue;
                ProjectionProperty[] cellProps = cellElem.getProjection().getProperties();
                ICell cell = (ICell)DiffHelper.getPropValue((ProjectionProperty[])cellProps, (String)"cell");
                diffCells.add(cell);
            }
            return this.makeFilter(table.getGridTable(), diffCells);
        }
        return null;
    }

    private IGridFilter makeFilter(IGridTable table, List<ICell> selectedCells) {
        ArrayList<IGridRegion> regions = new ArrayList<IGridRegion>();
        for (ICell cell : selectedCells) {
            IGridRegion region = ((IGridTable)table.getSubtable(cell.getColumn(), cell.getRow(), 1, 1)).getRegion();
            regions.add(region);
        }
        if (regions.isEmpty()) {
            return null;
        }
        IGridRegion[] aRegions = regions.toArray(new IGridRegion[regions.size()]);
        return new ColorGridFilter((IGridSelector)new RegionGridSelector(aRegions, true), WebStudioUtils.getWebStudio().getModel().getFilterHolder().makeFilter());
    }

    public void setDiffTree(DiffTreeNode diffTree) {
        this.diffTree = diffTree;
    }

    public DiffTreeNode getDiffTree() {
        return this.diffTree;
    }
}

