/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.repository;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.rules.webstudio.web.repository.RepositoryTreeState;
import org.openl.rules.webstudio.web.repository.tree.AbstractTreeNode;
import org.openl.rules.webstudio.web.repository.tree.TreeProject;
import org.openl.rules.workspace.abstracts.ProjectException;

public class DependencyBean {
    private String projectName;
    private String lowerVersion;
    private String upperVersion;

    public String delete() {
        AbstractTreeNode selectedNode;
        RepositoryTreeState treeState = (RepositoryTreeState)FacesUtils.getValueExpressionValue((String)"#{repositoryTreeState}");
        if (treeState != null && (selectedNode = treeState.getSelectedNode()) instanceof TreeProject) {
            TreeProject project = (TreeProject)selectedNode;
            try {
                project.removeDependency(this.projectName);
            }
            catch (ProjectException e) {
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(e.getMessage()));
                return "failure";
            }
        }
        return null;
    }

    public String getLowerVersion() {
        return this.lowerVersion;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getUpperVersion() {
        return this.upperVersion;
    }

    public String getVersionString() {
        StringBuilder sb = new StringBuilder(this.lowerVersion).append(" - ");
        if (this.upperVersion != null) {
            sb.append(this.upperVersion);
        } else {
            sb.append("...");
        }
        return sb.toString();
    }

    public void setLowerVersion(String lowerVersion) {
        this.lowerVersion = lowerVersion;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setUpperVersion(String upperVersion) {
        this.upperVersion = upperVersion;
    }
}

