/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.webstudio.web.repository.AbstractItem;
import org.openl.rules.webstudio.web.repository.RepositoryUtils;
import org.openl.rules.workspace.abstracts.DeploymentDescriptorProject;
import org.openl.rules.workspace.abstracts.Project;
import org.openl.rules.workspace.abstracts.ProjectDependency;
import org.openl.rules.workspace.abstracts.ProjectDescriptor;
import org.openl.rules.workspace.dtr.DesignTimeRepository;
import org.openl.rules.workspace.dtr.RepositoryException;
import org.openl.rules.workspace.uw.UserWorkspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyChecker {
    private static final Log LOG = LogFactory.getLog(DependencyChecker.class);
    private Map<String, CommonVersion> projectVersions = new HashMap<String, CommonVersion>();
    private Map<String, Map<String, VersionRange>> projectDependencies = new HashMap<String, Map<String, VersionRange>>();

    public void addProject(Project project) {
        String projectName = project.getName();
        this.projectVersions.put(projectName, (CommonVersion)project.getVersion());
        TreeMap<String, VersionRange> dependencies = new TreeMap<String, VersionRange>();
        this.projectDependencies.put(projectName, dependencies);
        for (ProjectDependency dependency : project.getDependencies()) {
            dependencies.put(dependency.getProjectName(), new VersionRange(dependency.getLowerLimit(), dependency.getUpperLimit()));
        }
    }

    public void addProjects(DeploymentDescriptorProject deploymentProject) {
        UserWorkspace workspace = RepositoryUtils.getWorkspace();
        if (workspace == null) {
            return;
        }
        DesignTimeRepository designRepository = workspace.getDesignTimeRepository();
        for (ProjectDescriptor descriptor : deploymentProject.getProjectDescriptors()) {
            String projectName = descriptor.getProjectName();
            CommonVersion projectVersion = descriptor.getProjectVersion();
            try {
                this.addProject((Project)designRepository.getProject(projectName, projectVersion));
            }
            catch (RepositoryException e) {
                String msg = "Cannot get project '" + projectName + "' version " + projectVersion.getVersionName() + "!";
                LOG.error((Object)msg, (Throwable)e);
                this.projectVersions.put(projectName, null);
            }
        }
    }

    public boolean check() {
        for (String projectName : this.projectVersions.keySet()) {
            if (this.checkProject(projectName, null)) continue;
            return false;
        }
        return true;
    }

    public boolean check(List<? extends AbstractItem> items) {
        boolean result = true;
        for (AbstractItem abstractItem : items) {
            if (this.checkProject(abstractItem.getName(), abstractItem)) continue;
            result = false;
        }
        return result;
    }

    protected boolean checkProject(String projectName, AbstractItem item) {
        if (this.projectVersions.get(projectName) == null) {
            if (item != null) {
                item.setMessages("Cannot find project <b>" + StringEscapeUtils.escapeHtml((String)projectName) + "</b> in the repository!");
                item.setStyleForMessages("text-error");
            }
            return false;
        }
        Map<String, VersionRange> dependencies = this.projectDependencies.get(projectName);
        for (Map.Entry<String, VersionRange> entry : dependencies.entrySet()) {
            String dependentName = entry.getKey();
            VersionRange range = entry.getValue();
            CommonVersion version = this.projectVersions.get(dependentName);
            if (version == null || range.isInRange(version)) continue;
            if (item != null) {
                item.setMessages("Conflicting with project <b>" + StringEscapeUtils.escapeHtml((String)dependentName) + "</b>! Valid versions are " + range.toString());
                item.setStyleForMessages("text-error");
            }
            return false;
        }
        for (String dependentProject : dependencies.keySet()) {
            if (this.projectVersions.containsKey(dependentProject)) continue;
            if (item != null) {
                item.setMessages("Dependent project <b>" + StringEscapeUtils.escapeHtml((String)dependentProject) + "</b> should be added too!");
                item.setStyleForMessages("text-warning");
            }
            return false;
        }
        return true;
    }

    private class VersionRange {
        private CommonVersion lower;
        private CommonVersion upper;

        private VersionRange(CommonVersion lower, CommonVersion upper) {
            this.lower = lower;
            this.upper = upper;
        }

        private boolean isInRange(CommonVersion version) {
            boolean a = this.lower.compareTo((Object)version) <= 0;
            boolean b = this.upper == null || this.upper.compareTo((Object)version) >= 0;
            return a && b;
        }

        public String toString() {
            if (this.upper == null) {
                return this.lower.getVersionName() + " - ...";
            }
            return this.lower.getVersionName() + " - " + this.upper.getVersionName();
        }
    }
}

