/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.repository;

import java.util.ArrayList;
import java.util.HashSet;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.rules.webstudio.web.repository.DependencyBean;
import org.openl.rules.webstudio.web.repository.RepositoryTreeState;
import org.openl.rules.webstudio.web.repository.tree.AbstractTreeNode;
import org.openl.rules.webstudio.web.repository.tree.TreeProject;
import org.openl.rules.webstudio.web.servlet.RulesUserSession;
import org.openl.rules.workspace.abstracts.ProjectDependency;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.abstracts.ProjectVersion;
import org.openl.rules.workspace.abstracts.impl.ProjectDependencyImpl;
import org.openl.rules.workspace.dtr.impl.RepositoryProjectVersionImpl;
import org.openl.rules.workspace.uw.UserWorkspace;
import org.openl.rules.workspace.uw.UserWorkspaceProject;

public class DependencyController {
    private static final Log LOG = LogFactory.getLog(DependencyController.class);
    private RepositoryTreeState repositoryTreeState;
    private String projectName;
    private String lowerVersion;
    private String upperVersion;

    public static ProjectVersion versionFromString(String s) {
        if (StringUtils.isEmpty((String)s) || s.startsWith(".") || s.endsWith("..")) {
            return null;
        }
        String[] parts = s.split("\\.");
        if (parts.length == 0 || parts.length > 3) {
            return null;
        }
        try {
            int rev;
            int major = Integer.parseInt(parts[0]);
            int minor = parts.length < 2 ? 0 : Integer.parseInt(parts[1]);
            int n = rev = parts.length < 3 ? 0 : Integer.parseInt(parts[2]);
            if (major < 0 || minor < 0 || rev < 0) {
                return null;
            }
            return new RepositoryProjectVersionImpl(major, minor, rev, null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String add() {
        AbstractTreeNode selected = this.repositoryTreeState.getSelectedNode();
        if (!(selected instanceof TreeProject)) {
            return null;
        }
        TreeProject project = (TreeProject)selected;
        ProjectDependencyImpl dependency = this.buildDependencyObject();
        if (dependency == null) {
            return null;
        }
        try {
            if (!project.addDependency((ProjectDependency)dependency)) {
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "duplicate dependency", null));
                return null;
            }
        }
        catch (ProjectException e) {
            LOG.error((Object)"Failed to add dependency!", (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, e.getMessage(), null));
            return null;
        }
        return null;
    }

    private ProjectDependencyImpl buildDependencyObject() {
        ProjectVersion projectVersion1 = DependencyController.versionFromString(this.lowerVersion);
        ProjectVersion projectVersion2 = null;
        if (projectVersion1 == null) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "lower version format error", "expected format - X[.Y[.Z]]"));
            return null;
        }
        if (!StringUtils.isEmpty((String)this.upperVersion) && (projectVersion2 = DependencyController.versionFromString(this.upperVersion)) == null) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "upper version format error", "expected format - X[.Y[.Z]]"));
            return null;
        }
        if (projectVersion2 != null && projectVersion1.compareTo((Object)projectVersion2) > 0) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "lower version is greater than upper one", null));
            return null;
        }
        return new ProjectDependencyImpl(this.projectName, projectVersion1, projectVersion2);
    }

    public SelectItem[] getAvailableProjects() {
        AbstractTreeNode selected = this.repositoryTreeState.getSelectedNode();
        HashSet<String> existing = new HashSet<String>();
        if (selected instanceof TreeProject) {
            for (DependencyBean dep : selected.getDependencies()) {
                existing.add(dep.getProjectName());
            }
            existing.add(selected.getName());
        }
        ArrayList<String> matching = new ArrayList<String>();
        for (AbstractTreeNode node : this.repositoryTreeState.getRulesRepository().getChildNodes()) {
            if (existing.contains(node.getName()) || ((UserWorkspaceProject)node.getDataBean()).isLocalOnly()) continue;
            matching.add(node.getName());
        }
        SelectItem[] result = new SelectItem[matching.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new SelectItem(matching.get(i));
        }
        return result;
    }

    public String getLowerVersion() {
        return this.lowerVersion;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public SelectItem[] getProjectVersions() {
        UserWorkspace workspace;
        try {
            workspace = this.getRulesUserSession().getUserWorkspace();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to get user workspace!", (Throwable)e);
            return new SelectItem[0];
        }
        if (this.projectName == null) {
            return new SelectItem[0];
        }
        try {
            UserWorkspaceProject project = (UserWorkspaceProject)workspace.getProject(this.projectName);
            ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
            for (ProjectVersion version : project.getVersions()) {
                selectItems.add(new SelectItem((Object)version.getVersionName()));
            }
            return selectItems.toArray(new SelectItem[selectItems.size()]);
        }
        catch (ProjectException e) {
            LOG.error((Object)"Cannot get project versions", (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(e.getMessage()));
            return new SelectItem[0];
        }
    }

    private RulesUserSession getRulesUserSession() {
        return (RulesUserSession)FacesUtils.getSessionParam((String)"rulesUserSession");
    }

    public String getUpperVersion() {
        return null;
    }

    public void setLowerVersion(String lowerVersion) {
        this.lowerVersion = lowerVersion;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setRepositoryTreeState(RepositoryTreeState repositoryTreeState) {
        this.repositoryTreeState = repositoryTreeState;
    }

    public void setUpperVersion(String upperVersion) {
        this.upperVersion = upperVersion;
    }
}

