/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.repository.CommonVersionImpl;
import org.openl.rules.webstudio.web.repository.DependencyChecker;
import org.openl.rules.webstudio.web.repository.DeploymentDescriptorItem;
import org.openl.rules.webstudio.web.repository.DeploymentManager;
import org.openl.rules.webstudio.web.repository.RepositoryTreeState;
import org.openl.rules.webstudio.web.repository.RepositoryUtils;
import org.openl.rules.workspace.abstracts.DeploymentDescriptorProject;
import org.openl.rules.workspace.abstracts.ProjectArtefact;
import org.openl.rules.workspace.abstracts.ProjectDescriptor;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.abstracts.ProjectVersion;
import org.openl.rules.workspace.deploy.DeployID;
import org.openl.rules.workspace.uw.UserWorkspace;
import org.openl.rules.workspace.uw.UserWorkspaceDeploymentProject;
import org.openl.rules.workspace.uw.UserWorkspaceProject;
import org.openl.rules.workspace.uw.impl.UserWorkspaceDeploymentProjectImpl;
import org.openl.rules.workspace.uw.impl.UserWorkspaceProjectDescriptorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentController {
    private static final Log LOG = LogFactory.getLog(DeploymentController.class);
    private List<DeploymentDescriptorItem> items;
    private String projectName;
    private String version;
    private RepositoryTreeState repositoryTreeState;
    private String cachedForProject;
    private DeploymentManager deploymentManager;

    public synchronized String addItem() {
        UserWorkspaceDeploymentProject project = this.getSelectedProject();
        UserWorkspaceProjectDescriptorImpl newItem = new UserWorkspaceProjectDescriptorImpl((UserWorkspaceDeploymentProjectImpl)project, this.projectName, (CommonVersion)new CommonVersionImpl(this.version));
        List<ProjectDescriptor> newDescriptors = this.replaceDescriptor(project, this.projectName, newItem);
        try {
            project.setProjectDescriptors(newDescriptors);
        }
        catch (ProjectException e) {
            LOG.error((Object)"Failed to add project descriptor!", (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "failed to add project descriptor", e.getMessage()));
        }
        return null;
    }

    private void checkConflicts(List<DeploymentDescriptorItem> items) throws ProjectException {
        if (items == null) {
            return;
        }
        DependencyChecker checker = new DependencyChecker();
        UserWorkspaceDeploymentProject project = this.getSelectedProject();
        checker.addProjects((DeploymentDescriptorProject)project);
        checker.check(items);
    }

    public String checkIn() {
        try {
            this.getSelectedProject().checkIn();
            this.items = null;
        }
        catch (ProjectException e) {
            LOG.error((Object)"Failed to check-in!", (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "failed to check in", e.getMessage()));
        }
        return null;
    }

    public String checkOut() {
        try {
            this.getSelectedProject().checkOut();
            this.items = null;
        }
        catch (ProjectException e) {
            LOG.error((Object)"Failed to check-out!", (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "failed to check out", e.getMessage()));
        }
        return null;
    }

    public String close() {
        try {
            this.getSelectedProject().close();
            this.items = null;
        }
        catch (ProjectException e) {
            LOG.error((Object)"Failed to close!", (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "failed to close deployment project", e.getMessage()));
        }
        return null;
    }

    public String deleteItem() {
        String projectName = FacesUtils.getRequestParameter((String)"key");
        UserWorkspaceDeploymentProject project = this.getSelectedProject();
        try {
            project.setProjectDescriptors(this.replaceDescriptor(project, projectName, null));
        }
        catch (ProjectException e) {
            LOG.error((Object)"Failed to delete project descriptor!", (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "failed to add project descriptor", e.getMessage()));
        }
        return null;
    }

    public String deploy() {
        UserWorkspaceDeploymentProject project = this.getSelectedProject();
        if (project != null) {
            try {
                DeployID id = this.deploymentManager.deploy(project);
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "Project '" + project.getName() + "' successfully deployed with id: " + id.getName(), null));
            }
            catch (Exception e) {
                String msg = "Failed to deploy '" + project.getName() + "'";
                LOG.error((Object)msg, (Throwable)e);
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, e.getMessage()));
            }
        }
        return null;
    }

    public synchronized List<DeploymentDescriptorItem> getItems() {
        UserWorkspaceDeploymentProject project = this.getSelectedProject();
        if (project == null) {
            return null;
        }
        String projectNameWithVersion = project.getName() + project.getVersion().getVersionName();
        if (this.items != null && projectNameWithVersion.equals(this.cachedForProject)) {
            return this.items;
        }
        this.cachedForProject = projectNameWithVersion;
        Collection descriptors = project.getProjectDescriptors();
        this.items = new ArrayList<DeploymentDescriptorItem>();
        for (ProjectDescriptor descriptor : descriptors) {
            DeploymentDescriptorItem item = new DeploymentDescriptorItem(descriptor.getProjectName(), descriptor.getProjectVersion());
            this.items.add(item);
        }
        try {
            this.checkConflicts(this.items);
        }
        catch (ProjectException e) {
            LOG.error((Object)"Failed to check conflicts!", (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, e.getMessage(), e.getMessage()));
        }
        return this.items;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public SelectItem[] getProjects() {
        UserWorkspace workspace = RepositoryUtils.getWorkspace();
        Collection workspaceProjects = workspace.getProjects();
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        List<DeploymentDescriptorItem> existingItems = this.getItems();
        HashSet<String> existing = new HashSet<String>();
        if (existingItems != null) {
            for (DeploymentDescriptorItem ddItem : existingItems) {
                existing.add(ddItem.getName());
            }
        }
        for (UserWorkspaceProject project : workspaceProjects) {
            if (project.isDeploymentProject() || existing.contains(project.getName()) || project.isLocalOnly()) continue;
            selectItems.add(new SelectItem((Object)project.getName()));
        }
        return selectItems.toArray(new SelectItem[selectItems.size()]);
    }

    public SelectItem[] getProjectVersions() {
        UserWorkspace workspace = RepositoryUtils.getWorkspace();
        if (this.projectName != null) {
            try {
                UserWorkspaceProject project = (UserWorkspaceProject)workspace.getProject(this.projectName);
                ArrayList versions = new ArrayList(project.getVersions());
                Collections.sort(versions, RepositoryUtils.VERSIONS_REVERSE_COMPARATOR);
                ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
                for (ProjectVersion version : versions) {
                    selectItems.add(new SelectItem((Object)version.getVersionName()));
                }
                return selectItems.toArray(new SelectItem[selectItems.size()]);
            }
            catch (ProjectException e) {
                LOG.error((Object)"Failed to get project versions!", (Throwable)e);
            }
        }
        return new SelectItem[0];
    }

    private UserWorkspaceDeploymentProject getSelectedProject() {
        ProjectArtefact artefact = this.repositoryTreeState.getSelectedNode().getDataBean();
        if (artefact instanceof UserWorkspaceDeploymentProject) {
            return (UserWorkspaceDeploymentProject)artefact;
        }
        return null;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isCheckinable() {
        return true;
    }

    public boolean isCheckoutable() {
        return true;
    }

    public String openSelectedProjects() {
        UserWorkspace workspace = RepositoryUtils.getWorkspace();
        for (DeploymentDescriptorItem item : this.items) {
            if (item.isSelected()) {
                String projectName = item.getName();
                try {
                    UserWorkspaceProject project = (UserWorkspaceProject)workspace.getProject(projectName);
                    if (!project.isOpened()) {
                        project.open();
                    }
                }
                catch (ProjectException e) {
                    LOG.error((Object)("Failed to open project '" + projectName + "'!"), (Throwable)e);
                }
            }
            item.setSelected(false);
        }
        return null;
    }

    private List<ProjectDescriptor> replaceDescriptor(UserWorkspaceDeploymentProject project, String projectName, UserWorkspaceProjectDescriptorImpl newItem) {
        ArrayList<ProjectDescriptor> newDescriptors = new ArrayList<ProjectDescriptor>();
        for (ProjectDescriptor pd : project.getProjectDescriptors()) {
            if (pd.getProjectName().equals(projectName)) {
                if (newItem == null) continue;
                newDescriptors.add((ProjectDescriptor)newItem);
                newItem = null;
                continue;
            }
            newDescriptors.add(pd);
        }
        if (newItem != null) {
            newDescriptors.add((ProjectDescriptor)newItem);
        }
        this.items = null;
        return newDescriptors;
    }

    public void setDeploymentManager(DeploymentManager deploymentManager) {
        this.deploymentManager = deploymentManager;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setRepositoryTreeState(RepositoryTreeState repositoryTreeState) {
        this.repositoryTreeState = repositoryTreeState;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

