/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.repository;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.webstudio.web.repository.RepositoryUtils;
import org.openl.rules.workspace.abstracts.ProjectDescriptor;
import org.openl.rules.workspace.deploy.DeployID;
import org.openl.rules.workspace.deploy.DeploymentException;
import org.openl.rules.workspace.deploy.ProductionDeployer;
import org.openl.rules.workspace.dtr.DesignTimeRepository;
import org.openl.rules.workspace.dtr.RepositoryException;
import org.openl.rules.workspace.dtr.RepositoryProject;
import org.openl.rules.workspace.uw.UserWorkspaceDeploymentProject;

public class DeploymentManager {
    private static final Log LOG = LogFactory.getLog(DeploymentManager.class);
    private ProductionDeployer deployer;

    public DeployID deploy(UserWorkspaceDeploymentProject project) throws RepositoryException, DeploymentException {
        DesignTimeRepository dtr = RepositoryUtils.getWorkspace().getDesignTimeRepository();
        Collection projectDescriptors = project.getProjectDescriptors();
        ArrayList<RepositoryProject> projects = new ArrayList<RepositoryProject>();
        for (ProjectDescriptor pd : projectDescriptors) {
            projects.add(dtr.getProject(pd.getProjectName(), pd.getProjectVersion()));
        }
        DeployID id = RepositoryUtils.getDeployID(project);
        this.deployer.deploy(id, projects);
        if (LOG.isDebugEnabled()) {
            String msg = "Project '" + project.getName() + "' successfully deployed with id:" + id.getName();
            LOG.debug((Object)msg);
        }
        return id;
    }

    public void setDeployer(ProductionDeployer deployer) {
        this.deployer = deployer;
    }
}

