/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.ui.WebStudio;
import org.openl.rules.webstudio.web.servlet.RulesUserSession;
import org.openl.rules.webstudio.web.util.WebStudioUtils;
import org.openl.rules.workspace.WorkspaceException;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.dtr.DesignTimeRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalUploadController {
    private static final Log LOG = LogFactory.getLog(LocalUploadController.class);
    private List<UploadBean> uploadBeans;

    private void createProject(File baseFolder, RulesUserSession rulesUserSession) throws ProjectException, WorkspaceException, FileNotFoundException {
        if (!baseFolder.isDirectory()) {
            throw new FileNotFoundException(baseFolder.getName());
        }
        rulesUserSession.getUserWorkspace().uploadLocalProject(baseFolder.getName());
    }

    public List<UploadBean> getProjects4Upload() {
        if (this.uploadBeans == null) {
            this.uploadBeans = new ArrayList<UploadBean>();
            RulesUserSession userRules = this.getRules();
            WebStudio webStudio = WebStudioUtils.getWebStudio();
            if (webStudio != null && userRules != null) {
                DesignTimeRepository dtr;
                try {
                    dtr = userRules.getUserWorkspace().getDesignTimeRepository();
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot get DTR!", (Throwable)e);
                    return null;
                }
                List projects = webStudio.getProjectResolver().listOpenLFolders();
                for (File f : projects) {
                    try {
                        if (dtr.hasProject(f.getName())) continue;
                        this.uploadBeans.add(new UploadBean(f.getName()));
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Failed to list projects for upload!", (Throwable)e);
                        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(e.getMessage()));
                    }
                }
            }
        }
        return this.uploadBeans;
    }

    private RulesUserSession getRules() {
        HttpSession session = ((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).getSession(false);
        return WebStudioUtils.getRulesUserSession(session);
    }

    public String upload() {
        String workspacePath = WebStudioUtils.getWebStudio().getWorkspacePath();
        RulesUserSession rulesUserSession = this.getRules();
        List<UploadBean> beans = this.uploadBeans;
        this.uploadBeans = null;
        if (beans != null) {
            for (UploadBean bean : beans) {
                if (!bean.isSelected()) continue;
                try {
                    this.createProject(new File(workspacePath, bean.getProjectName()), rulesUserSession);
                    FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "Project " + bean.getProjectName() + " was uploaded succesfully", null));
                }
                catch (Exception e) {
                    String msg = "Failed to upload local project '" + bean.getProjectName() + "'!";
                    LOG.error((Object)msg, (Throwable)e);
                    FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, e.getMessage()));
                }
            }
        }
        return null;
    }

    public static class UploadBean {
        private String projectName;
        private boolean selected;

        public UploadBean() {
        }

        public UploadBean(String projectName) {
            this.projectName = projectName;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }
}

