/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.repository.CommonVersionImpl;
import org.openl.rules.webstudio.filter.RepositoryFileExtensionFilter;
import org.openl.rules.webstudio.util.NameChecker;
import org.openl.rules.webstudio.web.repository.FileProjectResource;
import org.openl.rules.webstudio.web.repository.RepositoryArtefactPropsHolder;
import org.openl.rules.webstudio.web.repository.RepositoryTreeState;
import org.openl.rules.webstudio.web.repository.tree.AbstractTreeNode;
import org.openl.rules.webstudio.web.repository.tree.TreeRepository;
import org.openl.rules.webstudio.web.repository.upload.ExcelFileProjectCreator;
import org.openl.rules.webstudio.web.repository.upload.ProjectUploader;
import org.openl.rules.workspace.abstracts.ProjectArtefact;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.abstracts.ProjectResource;
import org.openl.rules.workspace.abstracts.ProjectVersion;
import org.openl.rules.workspace.filter.PathFilter;
import org.openl.rules.workspace.repository.RulesRepositoryArtefact;
import org.openl.rules.workspace.uw.UserWorkspace;
import org.openl.rules.workspace.uw.UserWorkspaceDeploymentProject;
import org.openl.rules.workspace.uw.UserWorkspaceProject;
import org.openl.rules.workspace.uw.UserWorkspaceProjectArtefact;
import org.openl.rules.workspace.uw.UserWorkspaceProjectFolder;
import org.openl.rules.workspace.uw.UserWorkspaceProjectResource;
import org.openl.rules.workspace.uw.impl.UserWorkspaceProjectImpl;
import org.openl.util.filter.OpenLFilter;
import org.richfaces.model.UploadItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryTreeController {
    private static final Date SPECIAL_DATE = new Date(0L);
    private static final Log LOG = LogFactory.getLog(RepositoryTreeController.class);
    private RepositoryTreeState repositoryTreeState;
    private UserWorkspace userWorkspace;
    private RepositoryArtefactPropsHolder repositoryArtefactPropsHolder;
    private String projectName;
    private String newProjectTemplate;
    private String[] projectTemplates = new String[]{"SampleTemplate.xls"};
    private String folderName;
    private List<UploadItem> uploadedFiles = new ArrayList<UploadItem>();
    private String fileName;
    private String uploadFrom;
    private String newProjectName;
    private String version;
    private int major;
    private int minor;
    private String filterString;
    private PathFilter zipFilter;

    public PathFilter getZipFilter() {
        return this.zipFilter;
    }

    public void setZipFilter(PathFilter zipFilter) {
        this.zipFilter = zipFilter;
    }

    public String addFile() {
        if (this.getLastUploadedFile() == null) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, null, "Please select file to be uploaded."));
            return null;
        }
        if (StringUtils.isEmpty((String)this.fileName)) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, null, "File name must not be empty."));
            return null;
        }
        String errorMessage = this.uploadAndAddFile();
        if (errorMessage == null) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("File was uploaded successfully."));
            this.repositoryTreeState.invalidateTree();
            this.repositoryTreeState.refreshSelectedNode();
        } else {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, null, errorMessage));
        }
        return null;
    }

    public String addFolder() {
        ProjectArtefact projectArtefact = this.repositoryTreeState.getSelectedNode().getDataBean();
        String errorMessage = null;
        if (projectArtefact instanceof UserWorkspaceProjectFolder) {
            if (NameChecker.checkName(this.folderName)) {
                UserWorkspaceProjectFolder folder = (UserWorkspaceProjectFolder)projectArtefact;
                try {
                    folder.addFolder(this.folderName);
                    this.repositoryTreeState.invalidateTree();
                    this.repositoryTreeState.refreshSelectedNode();
                }
                catch (ProjectException e) {
                    LOG.error((Object)("Failed to create folder '" + this.folderName + "'."), (Throwable)e);
                    errorMessage = e.getMessage();
                }
            } else {
                errorMessage = "Folder name '" + this.folderName + "' is invalid. " + NameChecker.BAD_NAME_MSG;
            }
        }
        if (errorMessage != null) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Failed to create folder.", errorMessage));
        }
        return null;
    }

    public String checkInProject() {
        try {
            this.repositoryTreeState.getSelectedProject().checkIn(this.major, this.minor);
            this.repositoryTreeState.invalidateTree();
        }
        catch (ProjectException e) {
            String msg = "Failed to check in project.";
            LOG.error((Object)msg, (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null));
        }
        return null;
    }

    public String checkOutProject() {
        try {
            this.repositoryTreeState.getSelectedProject().checkOut();
            this.repositoryTreeState.invalidateTree();
        }
        catch (ProjectException e) {
            String msg = "Failed to check out project.";
            LOG.error((Object)msg, (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, e.getMessage()));
        }
        return null;
    }

    public String closeProject() {
        try {
            this.repositoryTreeState.getSelectedProject().close();
            this.repositoryTreeState.invalidateTree();
            this.repositoryTreeState.refreshSelectedNode();
        }
        catch (ProjectException e) {
            String msg = "Failed to close project.";
            LOG.error((Object)msg, (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, e.getMessage()));
        }
        return null;
    }

    public String copyDeploymentProject() {
        UserWorkspaceDeploymentProject project;
        String errorMessage = null;
        try {
            project = this.userWorkspace.getDDProject(this.projectName);
        }
        catch (ProjectException e) {
            LOG.error((Object)("Cannot obtain deployment project '" + this.projectName + "'."), (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, null, e.getMessage()));
            return null;
        }
        if (project == null) {
            errorMessage = "No project is selected.";
        } else if (StringUtils.isBlank((String)this.newProjectName)) {
            errorMessage = "Project name is empty.";
        } else if (!NameChecker.checkName(this.newProjectName)) {
            errorMessage = "Project name '" + this.newProjectName + "' is invalid. " + NameChecker.BAD_NAME_MSG;
        } else if (this.userWorkspace.hasDDProject(this.newProjectName)) {
            errorMessage = "Deployment project '" + this.newProjectName + "' already exists.";
        }
        if (errorMessage != null) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Cannot copy deployment project.", errorMessage));
            return null;
        }
        try {
            this.userWorkspace.copyDDProject(project, this.newProjectName);
            this.repositoryTreeState.invalidateTree();
        }
        catch (ProjectException e) {
            String msg = "Failed to copy deployment project.";
            LOG.error((Object)msg, (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, e.getMessage()));
        }
        return null;
    }

    public String copyProject() {
        UserWorkspaceProject project;
        String errorMessage = null;
        try {
            project = (UserWorkspaceProject)this.userWorkspace.getProject(this.projectName);
        }
        catch (ProjectException e) {
            LOG.error((Object)("Cannot obtain rules project '" + this.projectName + "'."), (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, null, e.getMessage()));
            return null;
        }
        if (project == null) {
            errorMessage = "No project is selected.";
        } else if (StringUtils.isBlank((String)this.newProjectName)) {
            errorMessage = "Project name is empty.";
        } else if (!NameChecker.checkName(this.newProjectName)) {
            errorMessage = "Project name '" + this.newProjectName + "' is invalid. " + NameChecker.BAD_NAME_MSG;
        } else if (this.userWorkspace.hasProject(this.newProjectName)) {
            boolean isLocalOnly;
            try {
                isLocalOnly = ((UserWorkspaceProject)this.userWorkspace.getProject(this.newProjectName)).isLocalOnly();
            }
            catch (ProjectException e) {
                isLocalOnly = false;
            }
            if (!isLocalOnly) {
                errorMessage = "Project '" + this.newProjectName + "' already exists.";
            }
        }
        if (errorMessage != null) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Cannot copy project.", errorMessage));
            return null;
        }
        try {
            this.userWorkspace.copyProject(project, this.newProjectName);
            this.repositoryTreeState.invalidateTree();
        }
        catch (ProjectException e) {
            String msg = "Failed to copy project.";
            LOG.error((Object)msg, (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, e.getMessage()));
        }
        return null;
    }

    public String createDeploymentProject() {
        try {
            this.userWorkspace.createDDProject(this.projectName);
            this.repositoryTreeState.invalidateTree();
        }
        catch (ProjectException e) {
            String msg = "Failed to create deployment project '" + this.projectName + "'.";
            LOG.error((Object)msg, (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, e.getMessage()));
        }
        return null;
    }

    public String createNewRulesProject() {
        InputStream sampleRulesSource = this.getClass().getClassLoader().getResourceAsStream(this.newProjectTemplate);
        String errorMessage = String.format("Can`t load template file: %s", this.newProjectTemplate);
        if (sampleRulesSource == null) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, null, errorMessage));
            return null;
        }
        String rulesSourceName = "rules." + FilenameUtils.getExtension((String)this.newProjectTemplate);
        this.repositoryTreeState.invalidateTree();
        ExcelFileProjectCreator projectCreator = new ExcelFileProjectCreator(this.projectName, this.userWorkspace, sampleRulesSource, rulesSourceName);
        return projectCreator.createRulesProject();
    }

    public String deleteDeploymentProject() {
        String projectName = FacesUtils.getRequestParameter((String)"deploymentProjectName");
        try {
            UserWorkspaceDeploymentProject project = this.userWorkspace.getDDProject(projectName);
            project.delete();
            this.repositoryTreeState.invalidateTree();
        }
        catch (ProjectException e) {
            LOG.error((Object)("Cannot delete deployment project '" + projectName + "'."), (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Failed to delete deployment project.", e.getMessage()));
        }
        return null;
    }

    public String deleteElement() {
        UserWorkspaceProjectArtefact projectArtefact = (UserWorkspaceProjectArtefact)this.repositoryTreeState.getSelectedNode().getDataBean();
        String childName = FacesUtils.getRequestParameter((String)"element");
        try {
            projectArtefact.getArtefact(childName).delete();
            this.repositoryTreeState.invalidateTree();
            this.repositoryTreeState.refreshSelectedNode();
        }
        catch (ProjectException e) {
            LOG.error((Object)"Error deleting element.", (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Error deleting.", e.getMessage()));
        }
        return null;
    }

    public String deleteNode() {
        UserWorkspaceProjectArtefact projectArtefact = (UserWorkspaceProjectArtefact)this.repositoryTreeState.getSelectedNode().getDataBean();
        try {
            projectArtefact.delete();
            this.repositoryTreeState.invalidateTree();
            if (projectArtefact instanceof UserWorkspaceProjectImpl) {
                UserWorkspaceProjectImpl project = (UserWorkspaceProjectImpl)projectArtefact;
                if (project.isLocalOnly()) {
                    this.repositoryTreeState.invalidateSelection();
                    return null;
                }
                this.repositoryTreeState.refreshSelectedNode();
                return null;
            }
            this.repositoryTreeState.moveSelectionToParentNode();
        }
        catch (ProjectException e) {
            LOG.error((Object)"Failed to delete node.", (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Failed to delete node.", e.getMessage()));
        }
        return null;
    }

    public String deleteRulesProject() {
        String projectName = FacesUtils.getRequestParameter((String)"projectName");
        try {
            UserWorkspaceProject project = (UserWorkspaceProject)this.userWorkspace.getProject(projectName);
            project.delete();
            this.repositoryTreeState.invalidateTree();
        }
        catch (ProjectException e) {
            LOG.error((Object)("Cannot delete rules project '" + projectName + "'."), (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Failed to delete rules project.", e.getMessage()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String eraseProject() {
        UserWorkspaceProject project = this.repositoryTreeState.getSelectedProject();
        if (project == null) {
            return null;
        }
        if (!project.isDeleted()) {
            this.repositoryTreeState.invalidateTree();
            this.repositoryTreeState.invalidateSelection();
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, null, "Cannot erase project '" + project.getName() + "'. It must be marked for deletion first!"));
            return null;
        }
        try {
            project.erase();
        }
        catch (ProjectException e) {
            String msg = "Cannot erase project '" + project.getName() + "'.";
            LOG.error((Object)msg, (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, null, msg));
        }
        finally {
            this.repositoryTreeState.invalidateTree();
            this.repositoryTreeState.invalidateSelection();
        }
        return null;
    }

    public String exportProjectVersion() {
        File zipFile = null;
        String zipFileName = null;
        try {
            UserWorkspaceProject p = this.repositoryTreeState.getSelectedProject();
            zipFile = p.exportVersion((CommonVersion)new CommonVersionImpl(this.version));
            zipFileName = String.format("%s-%s.zip", p.getName(), this.version);
        }
        catch (ProjectException e) {
            String msg = "Failed to export project version.";
            LOG.error((Object)msg, (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, e.getMessage()));
        }
        if (zipFile != null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
            this.writeOutContent(response, zipFile, zipFileName);
            facesContext.responseComplete();
            zipFile.delete();
        }
        return null;
    }

    public String filter() {
        RepositoryFileExtensionFilter filter = null;
        if (StringUtils.isNotBlank((String)this.filterString)) {
            filter = new RepositoryFileExtensionFilter(this.filterString);
        }
        this.repositoryTreeState.setFilter((OpenLFilter)filter);
        return null;
    }

    public String getAttribute1() {
        return (String)this.getProperty("attribute1");
    }

    public Date getAttribute10() {
        return this.getDateProperty("attribute10");
    }

    public String getAttribute11() {
        return this.getNumberProperty("attribute11");
    }

    public String getAttribute12() {
        return this.getNumberProperty("attribute12");
    }

    public String getAttribute13() {
        return this.getNumberProperty("attribute13");
    }

    public String getAttribute14() {
        return this.getNumberProperty("attribute14");
    }

    public String getAttribute15() {
        return this.getNumberProperty("attribute15");
    }

    public String getAttribute2() {
        return (String)this.getProperty("attribute2");
    }

    public String getAttribute3() {
        return (String)this.getProperty("attribute3");
    }

    public String getAttribute4() {
        return (String)this.getProperty("attribute4");
    }

    public String getAttribute5() {
        return (String)this.getProperty("attribute5");
    }

    public Date getAttribute6() {
        return this.getDateProperty("attribute6");
    }

    public Date getAttribute7() {
        return this.getDateProperty("attribute7");
    }

    public Date getAttribute8() {
        return this.getDateProperty("attribute8");
    }

    public Date getAttribute9() {
        return this.getDateProperty("attribute9");
    }

    private Date getDateProperty(String propName) {
        Object prop = this.getProperty(propName);
        if (prop instanceof Date) {
            return (Date)prop;
        }
        if (prop instanceof Long) {
            return new Date((Long)prop);
        }
        return null;
    }

    public String getDeploymentProjectName() {
        return null;
    }

    public List<AbstractTreeNode> getDeploymentProjects() {
        return this.repositoryTreeState.getDeploymentRepository().getChildNodes();
    }

    public Date getEffectiveDate() {
        RulesRepositoryArtefact dataBean = (RulesRepositoryArtefact)this.repositoryTreeState.getSelectedNode().getDataBean();
        if (dataBean != null) {
            return dataBean.getEffectiveDate();
        }
        return null;
    }

    public Date getExpirationDate() {
        RulesRepositoryArtefact dataBean = (RulesRepositoryArtefact)this.repositoryTreeState.getSelectedNode().getDataBean();
        if (dataBean != null) {
            return dataBean.getExpirationDate();
        }
        return null;
    }

    public String getFileName() {
        return null;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public String getFolderName() {
        return null;
    }

    public String getLineOfBusiness() {
        RulesRepositoryArtefact dataBean = (RulesRepositoryArtefact)this.repositoryTreeState.getSelectedNode().getDataBean();
        if (dataBean != null) {
            return dataBean.getLineOfBusiness();
        }
        return null;
    }

    public int getMajor() {
        ProjectVersion v = this.getProjectVersion();
        if (v != null) {
            return v.getMajor();
        }
        return this.major;
    }

    public int getMinor() {
        ProjectVersion v = this.getProjectVersion();
        if (v != null) {
            return v.getMinor();
        }
        return this.minor;
    }

    public String getNewProjectName() {
        return null;
    }

    private String getNumberProperty(String propName) {
        Object prop = this.getProperty(propName);
        if (prop instanceof Double) {
            return String.valueOf(prop);
        }
        return null;
    }

    public String getProjectName() {
        return null;
    }

    private ProjectVersion getProjectVersion() {
        UserWorkspaceProject project = this.repositoryTreeState.getSelectedProject();
        if (project != null) {
            return project.getVersion();
        }
        return null;
    }

    public Map<String, Object> getProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        return properties;
    }

    private Object getProperty(String propName) {
        Map<String, Object> props = this.getProps();
        if (props != null) {
            return props.get(propName);
        }
        return null;
    }

    private Map<String, Object> getProps() {
        RulesRepositoryArtefact dataBean = (RulesRepositoryArtefact)this.repositoryTreeState.getSelectedNode().getDataBean();
        if (dataBean != null) {
            return dataBean.getProps();
        }
        return null;
    }

    private String getPropUIName(String propName) {
        if (propName == null) {
            return "";
        }
        String propUIName = this.getPropUINames().get(propName);
        if (StringUtils.isBlank((String)propUIName)) {
            propUIName = propName;
        }
        return propUIName;
    }

    public Map<String, String> getPropUINames() {
        return this.repositoryArtefactPropsHolder.getProps();
    }

    public int getRevision() {
        ProjectVersion v = this.getProjectVersion();
        if (v != null) {
            return v.getRevision();
        }
        return 0;
    }

    public List<AbstractTreeNode> getRulesProjects() {
        return this.repositoryTreeState.getRulesRepository().getChildNodes();
    }

    public SelectItem[] getSelectedProjectVersions() {
        Collection<ProjectVersion> versions = this.repositoryTreeState.getSelectedNode().getVersions();
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (ProjectVersion version : versions) {
            selectItems.add(new SelectItem((Object)version.getVersionName()));
        }
        return selectItems.toArray(new SelectItem[selectItems.size()]);
    }

    public String getUploadFrom() {
        return this.uploadFrom;
    }

    public String getVersion() {
        return this.version;
    }

    public String openProject() {
        try {
            this.repositoryTreeState.getSelectedProject().open();
            this.repositoryTreeState.invalidateTree();
        }
        catch (ProjectException e) {
            String msg = "Failed to open project.";
            LOG.error((Object)msg, (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, e.getMessage()));
        }
        return null;
    }

    public String openProjectVersion() {
        try {
            this.repositoryTreeState.getSelectedProject().openVersion((CommonVersion)new CommonVersionImpl(this.version));
            this.repositoryTreeState.invalidateTree();
        }
        catch (ProjectException e) {
            String msg = "Failed to open project version.";
            LOG.error((Object)msg, (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, e.getMessage()));
        }
        return null;
    }

    public String refreshTree() {
        this.repositoryTreeState.invalidateTree();
        this.repositoryTreeState.invalidateSelection();
        return null;
    }

    public String selectDeploymentProject() {
        String projectName = FacesUtils.getRequestParameter((String)"projectName");
        this.selectProject(projectName, this.repositoryTreeState.getDeploymentRepository());
        return null;
    }

    private void selectProject(String projectName, TreeRepository root) {
        for (AbstractTreeNode node : root.getChildNodes()) {
            if (!node.getName().equals(projectName)) continue;
            this.repositoryTreeState.setSelectedNode(node);
            this.repositoryTreeState.refreshSelectedNode();
            break;
        }
    }

    public String selectRulesProject() {
        String projectName = FacesUtils.getRequestParameter((String)"projectName");
        this.selectProject(projectName, this.repositoryTreeState.getRulesRepository());
        return null;
    }

    public void setAttribute1(String attribute1) {
        this.setProperty("attribute1", attribute1);
    }

    public void setAttribute10(Date attribute10) {
        this.setDateProperty("attribute10", attribute10);
    }

    public void setAttribute11(String attribute11) {
        this.setNumberProperty("attribute11", attribute11);
    }

    public void setAttribute12(String attribute12) {
        this.setNumberProperty("attribute12", attribute12);
    }

    public void setAttribute13(String attribute13) {
        this.setNumberProperty("attribute13", attribute13);
    }

    public void setAttribute14(String attribute14) {
        this.setNumberProperty("attribute14", attribute14);
    }

    public void setAttribute15(String attribute15) {
        this.setNumberProperty("attribute15", attribute15);
    }

    public void setAttribute2(String attribute2) {
        this.setProperty("attribute2", attribute2);
    }

    public void setAttribute3(String attribute3) {
        this.setProperty("attribute3", attribute3);
    }

    public void setAttribute4(String attribute4) {
        this.setProperty("attribute4", attribute4);
    }

    public void setAttribute5(String attribute5) {
        this.setProperty("attribute5", attribute5);
    }

    public void setAttribute6(Date attribute6) {
        this.setDateProperty("attribute6", attribute6);
    }

    public void setAttribute7(Date attribute7) {
        this.setDateProperty("attribute7", attribute7);
    }

    public void setAttribute8(Date attribute8) {
        this.setDateProperty("attribute8", attribute8);
    }

    public void setAttribute9(Date attribute9) {
        this.setDateProperty("attribute9", attribute9);
    }

    public void setDateProperty(String propName, Date propValue) {
        if (!SPECIAL_DATE.equals(propValue)) {
            this.setProperty(propName, propValue);
        } else {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, null, "Specified " + this.getPropUIName(propName) + " value is not a valid date."));
        }
    }

    public void setEffectiveDate(Date date) {
        if (!SPECIAL_DATE.equals(date)) {
            try {
                ((RulesRepositoryArtefact)this.repositoryTreeState.getSelectedNode().getDataBean()).setEffectiveDate(date);
            }
            catch (ProjectException e) {
                LOG.error((Object)"Failed to set effective date!", (Throwable)e);
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Can not set effective date.", e.getMessage()));
            }
        } else {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, null, "Specified effective date value is not a valid date."));
        }
    }

    public void setExpirationDate(Date date) {
        if (!SPECIAL_DATE.equals(date)) {
            try {
                ((RulesRepositoryArtefact)this.repositoryTreeState.getSelectedNode().getDataBean()).setExpirationDate(date);
            }
            catch (ProjectException e) {
                LOG.error((Object)"Failed to set expiration date!", (Throwable)e);
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Can not set expiration date.", e.getMessage()));
            }
        } else {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, null, "Specified expiration date value is not a valid date."));
        }
    }

    public List<UploadItem> getUploadedFiles() {
        return this.uploadedFiles;
    }

    public void setUploadedFiles(List<UploadItem> uploadedFiles) {
        this.uploadedFiles = uploadedFiles;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public void setLineOfBusiness(String lineOfBusiness) {
        try {
            ((RulesRepositoryArtefact)this.repositoryTreeState.getSelectedNode().getDataBean()).setLineOfBusiness(lineOfBusiness);
        }
        catch (ProjectException e) {
            LOG.error((Object)"Failed to set LOB!", (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Can not set line of business.", e.getMessage()));
        }
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public void setNewProjectName(String newProjectName) {
        this.newProjectName = newProjectName;
    }

    public void setNumberProperty(String propName, String propValue) {
        Double numberValue = null;
        try {
            if (StringUtils.isNotBlank((String)propValue)) {
                numberValue = Double.valueOf(propValue);
            }
            this.setProperty(propName, numberValue);
        }
        catch (NumberFormatException e) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, null, "Specified " + this.getPropUIName(propName) + " value is not a number."));
        }
    }

    public void setProjectName(String newProjectName) {
        this.projectName = newProjectName;
    }

    private void setProperty(String propName, Object propValue) {
        try {
            Map<String, Object> props = this.getProps();
            props = props == null ? new HashMap<String, Object>() : new HashMap<String, Object>(props);
            props.put(propName, propValue);
            ((RulesRepositoryArtefact)this.repositoryTreeState.getSelectedNode().getDataBean()).setProps(props);
        }
        catch (ProjectException e) {
            String propUIName = this.getPropUIName(propName);
            LOG.error((Object)("Failed to set " + propUIName + "!"), (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Can not set " + propUIName + ".", e.getMessage()));
        }
    }

    public void setRepositoryArtefactPropsHolder(RepositoryArtefactPropsHolder repositoryArtefactPropsHolder) {
        this.repositoryArtefactPropsHolder = repositoryArtefactPropsHolder;
    }

    public void setRepositoryTreeState(RepositoryTreeState repositoryTreeState) {
        this.repositoryTreeState = repositoryTreeState;
    }

    public void setUploadFrom(String uploadFrom) {
        this.uploadFrom = uploadFrom;
    }

    public void setUserWorkspace(UserWorkspace userWorkspace) {
        this.userWorkspace = userWorkspace;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String undeleteProject() {
        UserWorkspaceProject project = this.repositoryTreeState.getSelectedProject();
        if (!project.isDeleted()) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Cannot undelete project '" + project.getName() + "'.", "Project is not marked for deletion."));
            return null;
        }
        try {
            project.undelete();
            this.repositoryTreeState.invalidateTree();
        }
        catch (ProjectException e) {
            String msg = "Cannot undelete project '" + project.getName() + "'.";
            LOG.error((Object)msg, (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, e.getMessage()));
        }
        return null;
    }

    public String updateFile() {
        if (this.getLastUploadedFile() == null) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, null, "Please select file to be uploaded."));
            return null;
        }
        String errorMessage = this.uploadAndUpdateFile();
        if (errorMessage == null) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("File was successfully updated."));
            this.repositoryTreeState.invalidateTree();
        } else {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, errorMessage, "Error occured during uploading file."));
        }
        return null;
    }

    public String upload() {
        String errorMessage = this.uploadProject();
        if (errorMessage == null) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Project was uploaded successfully."));
            this.repositoryTreeState.invalidateTree();
        } else {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, null, "Error while uploading project."));
        }
        return null;
    }

    private String uploadAndAddFile() {
        if (!NameChecker.checkName(this.fileName)) {
            return "File name '" + this.fileName + "' is invalid. " + NameChecker.BAD_NAME_MSG;
        }
        File uploadedFile = this.getLastUploadedFile().getFile();
        try {
            UserWorkspaceProjectFolder node = (UserWorkspaceProjectFolder)this.repositoryTreeState.getSelectedNode().getDataBean();
            FileProjectResource projectResource = new FileProjectResource(new FileInputStream(uploadedFile));
            node.addResource(this.fileName, (ProjectResource)projectResource);
            this.clearUploadedFiles();
        }
        catch (Exception e) {
            LOG.error((Object)"Error adding file to user workspace.", (Throwable)e);
            return e.getMessage();
        }
        return null;
    }

    private String uploadAndUpdateFile() {
        File uploadedFile = this.getLastUploadedFile().getFile();
        try {
            UserWorkspaceProjectResource node = (UserWorkspaceProjectResource)this.repositoryTreeState.getSelectedNode().getDataBean();
            node.setContent((InputStream)new FileInputStream(uploadedFile));
            this.clearUploadedFiles();
        }
        catch (Exception e) {
            LOG.error((Object)"Error updating file in user workspace.", (Throwable)e);
            return e.getMessage();
        }
        return null;
    }

    private UploadItem getLastUploadedFile() {
        if (!this.uploadedFiles.isEmpty()) {
            return this.uploadedFiles.get(this.uploadedFiles.size() - 1);
        }
        return null;
    }

    private String uploadProject() {
        String errorMessage = null;
        UploadItem uploadedItem = this.getLastUploadedFile();
        if (uploadedItem != null) {
            ProjectUploader projectUploader = new ProjectUploader(uploadedItem, this.projectName, this.userWorkspace, this.zipFilter);
            errorMessage = projectUploader.uploadProject();
        } else {
            errorMessage = "There are no uploaded files .";
        }
        this.processErrorMessage(errorMessage);
        return errorMessage;
    }

    private void processErrorMessage(String errorMessage) {
        if (errorMessage == null) {
            this.repositoryTreeState.invalidateTree();
            this.clearUploadedFiles();
        } else {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, null, errorMessage));
        }
    }

    private void clearUploadedFiles() {
        for (UploadItem uploadFile : this.uploadedFiles) {
            uploadFile.getFile().delete();
        }
        this.uploadedFiles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutContent(HttpServletResponse res, File content, String theFilename) {
        String msg;
        if (content == null) {
            return;
        }
        FileInputStream input = null;
        try {
            res.setHeader("Pragma", "no-cache");
            res.setDateHeader("Expires", 0L);
            res.setContentType("application/zip");
            res.setHeader("Content-disposition", "attachment; filename=" + theFilename);
            input = new FileInputStream(content);
            IOUtils.copy((InputStream)input, (OutputStream)res.getOutputStream());
        }
        catch (IOException e) {
            msg = "Failed to write content of '" + content.getAbsolutePath() + "' into response!";
            LOG.error((Object)msg, (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, e.getMessage()));
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    msg = "Failed to close content stream.";
                    LOG.error((Object)msg, (Throwable)e);
                }
            }
        }
    }

    public String getNewProjectTemplate() {
        return this.newProjectTemplate;
    }

    public void setNewProjectTemplate(String newProjectTemplate) {
        this.newProjectTemplate = newProjectTemplate;
    }

    public SelectItem[] getNewProjectTemplates() {
        return FacesUtils.createSelectItems((String[])this.projectTemplates);
    }
}

