/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.webstudio.web.repository.RepositoryUtils;
import org.openl.rules.webstudio.web.repository.tree.AbstractTreeNode;
import org.openl.rules.webstudio.web.repository.tree.TreeDProject;
import org.openl.rules.webstudio.web.repository.tree.TreeFile;
import org.openl.rules.webstudio.web.repository.tree.TreeFolder;
import org.openl.rules.webstudio.web.repository.tree.TreeProject;
import org.openl.rules.webstudio.web.repository.tree.TreeRepository;
import org.openl.rules.workspace.abstracts.DeploymentDescriptorProject;
import org.openl.rules.workspace.abstracts.Project;
import org.openl.rules.workspace.abstracts.ProjectArtefact;
import org.openl.rules.workspace.abstracts.ProjectFolder;
import org.openl.rules.workspace.dtr.RepositoryException;
import org.openl.rules.workspace.uw.UserWorkspace;
import org.openl.rules.workspace.uw.UserWorkspaceDeploymentProject;
import org.openl.rules.workspace.uw.UserWorkspaceProject;
import org.openl.util.filter.AllOpenLFilter;
import org.openl.util.filter.OpenLFilter;
import org.richfaces.component.UITree;
import org.richfaces.event.NodeSelectedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryTreeState {
    private static final Log LOG = LogFactory.getLog(RepositoryTreeState.class);
    private TreeRepository root;
    private AbstractTreeNode selectedNode;
    private TreeRepository rulesRepository;
    private TreeRepository deploymentRepository;
    private UserWorkspace userWorkspace;
    private OpenLFilter filter = AllOpenLFilter.INSTANCE;

    public Boolean adviseNodeSelected(UITree uiTree) {
        AbstractTreeNode node = (AbstractTreeNode)uiTree.getRowData();
        ProjectArtefact projectArtefact = node.getDataBean();
        ProjectArtefact selected = this.selectedNode.getDataBean();
        if (selected == null || projectArtefact == null) {
            return this.selectedNode.getId().equals(node.getId());
        }
        if (selected.getArtefactPath().equals(projectArtefact.getArtefactPath())) {
            if (projectArtefact instanceof DeploymentDescriptorProject) {
                return selected instanceof DeploymentDescriptorProject;
            }
            return true;
        }
        return false;
    }

    private void buildTree() {
        if (this.root != null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Starting buildTree()");
        }
        this.root = new TreeRepository("", "", "root");
        String rpName = "Rules Projects";
        this.rulesRepository = new TreeRepository(rpName, rpName, "repository");
        this.rulesRepository.setDataBean(null);
        if (this.selectedNode == null) {
            this.selectedNode = this.rulesRepository;
        }
        String dpName = "Deployment Projects";
        this.deploymentRepository = new TreeRepository(dpName, dpName, "drepository");
        this.deploymentRepository.setDataBean(null);
        this.root.add(this.rulesRepository);
        this.root.add(this.deploymentRepository);
        Collection rulesProjects = this.userWorkspace.getProjects();
        OpenLFilter filter = this.filter;
        for (UserWorkspaceProject project : rulesProjects) {
            if (filter.supports(Project.class) && !filter.select((Object)project)) continue;
            TreeProject prj = new TreeProject(project.getName(), project.getName());
            if (this.isProjectCurrentlySelected((Project)project)) {
                this.selectedNode = prj;
            }
            prj.setDataBean((ProjectArtefact)project);
            this.rulesRepository.add(prj);
            this.traverseFolder(prj, project.getArtefacts(), filter);
        }
        List deploymentsProjects = null;
        try {
            deploymentsProjects = this.userWorkspace.getDDProjects();
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Cannot get deployment projects", (Throwable)e);
        }
        for (UserWorkspaceDeploymentProject project : deploymentsProjects) {
            TreeDProject prj = new TreeDProject(dpName + "/" + project.getName(), project.getName());
            prj.setDataBean((ProjectArtefact)project);
            this.deploymentRepository.add(prj);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Finishing buildTree()");
        }
    }

    private boolean isProjectCurrentlySelected(Project project) {
        return this.selectedNode != null && this.selectedNode.getDataBean() == project;
    }

    public TreeRepository getDeploymentRepository() {
        this.buildTree();
        return this.deploymentRepository;
    }

    public OpenLFilter getFilter() {
        return this.filter;
    }

    public TreeRepository getRoot() {
        this.buildTree();
        return this.root;
    }

    public TreeRepository getRulesRepository() {
        this.buildTree();
        return this.rulesRepository;
    }

    public AbstractTreeNode getSelectedNode() {
        this.buildTree();
        return this.selectedNode;
    }

    public UserWorkspaceProject getSelectedProject() {
        ProjectArtefact artefact = this.getSelectedNode().getDataBean();
        if (artefact instanceof UserWorkspaceProject) {
            return (UserWorkspaceProject)artefact;
        }
        return null;
    }

    public void invalidateSelection() {
        this.selectedNode = null;
    }

    public void invalidateTree() {
        this.root = null;
    }

    public void moveSelectionToParentNode() {
        Iterator it = this.getSelectedNode().getDataBean().getArtefactPath().getSegments().iterator();
        TreeRepository prevNode = null;
        for (TreeRepository node = this.getRulesRepository(); node != null && it.hasNext(); node = node.getChild(it.next())) {
            prevNode = node;
        }
        if (prevNode != null) {
            this.selectedNode = prevNode;
        }
    }

    public void processSelection(NodeSelectedEvent event) {
        UITree tree = (UITree)event.getComponent();
        try {
            this.selectedNode = (AbstractTreeNode)tree.getRowData();
        }
        catch (IllegalStateException ex) {
            this.selectedNode = this.getSelectedNode();
        }
    }

    public void refreshSelectedNode() {
        TreeRepository currentNode;
        Iterator it = this.getSelectedNode().getDataBean().getArtefactPath().getSegments().iterator();
        for (currentNode = this.getRulesRepository(); currentNode != null && it.hasNext(); currentNode = currentNode.getChild(it.next())) {
        }
        if (currentNode != null) {
            this.selectedNode = currentNode;
        }
    }

    public void setFilter(OpenLFilter filter) {
        this.filter = filter != null ? filter : AllOpenLFilter.INSTANCE;
        this.root = null;
    }

    public void setRoot(TreeRepository root) {
        this.root = root;
    }

    public void setSelectedNode(AbstractTreeNode selectedNode) {
        this.selectedNode = selectedNode;
    }

    public void setUserWorkspace(UserWorkspace userWorkspace) {
        this.userWorkspace = userWorkspace;
    }

    private void traverseFolder(TreeFolder folder, Collection<? extends ProjectArtefact> artefacts, OpenLFilter filter) {
        ArrayList<ProjectArtefact> filteredArtefacts = new ArrayList<ProjectArtefact>();
        for (ProjectArtefact projectArtefact : artefacts) {
            if (filter.supports(projectArtefact.getClass()) && !filter.select((Object)projectArtefact)) continue;
            filteredArtefacts.add(projectArtefact);
        }
        ProjectArtefact[] sortedArtefacts = new ProjectArtefact[filteredArtefacts.size()];
        sortedArtefacts = filteredArtefacts.toArray(sortedArtefacts);
        Arrays.sort(sortedArtefacts, RepositoryUtils.ARTEFACT_COMPARATOR);
        for (ProjectArtefact artefact : sortedArtefacts) {
            String id = artefact.getName();
            if (artefact.isFolder()) {
                TreeFolder treeFolder = new TreeFolder(id, artefact.getName());
                treeFolder.setDataBean(artefact);
                folder.add(treeFolder);
                this.traverseFolder(treeFolder, ((ProjectFolder)artefact).getArtefacts(), filter);
                continue;
            }
            TreeFile treeFile = new TreeFile(id, artefact.getName());
            treeFile.setDataBean(artefact);
            folder.add(treeFile);
        }
    }
}

