/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.repository;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.repository.CommonVersionImpl;
import org.openl.rules.webstudio.web.repository.DependencyChecker;
import org.openl.rules.webstudio.web.repository.DeploymentManager;
import org.openl.rules.webstudio.web.repository.DeploymentProjectItem;
import org.openl.rules.webstudio.web.repository.RepositoryTreeState;
import org.openl.rules.webstudio.web.repository.RepositoryUtils;
import org.openl.rules.webstudio.web.repository.tree.AbstractTreeNode;
import org.openl.rules.workspace.abstracts.DeploymentDescriptorProject;
import org.openl.rules.workspace.abstracts.Project;
import org.openl.rules.workspace.abstracts.ProjectArtefact;
import org.openl.rules.workspace.abstracts.ProjectDescriptor;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.deploy.DeployID;
import org.openl.rules.workspace.dtr.RepositoryException;
import org.openl.rules.workspace.uw.UserWorkspace;
import org.openl.rules.workspace.uw.UserWorkspaceDeploymentProject;
import org.openl.rules.workspace.uw.UserWorkspaceProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartRedeployController {
    private static final Log LOG = LogFactory.getLog(SmartRedeployController.class);
    private RepositoryTreeState repositoryTreeState;
    private List<DeploymentProjectItem> items;
    private DeploymentManager deploymentManager;

    public synchronized List<DeploymentProjectItem> getItems() {
        UserWorkspaceProject project = this.getSelectedProject();
        if (project == null) {
            this.items = null;
            return null;
        }
        this.items = this.getItems4Project(project);
        return this.items;
    }

    private List<DeploymentProjectItem> getItems4Project(UserWorkspaceProject project) {
        String projectName = project.getName();
        UserWorkspace workspace = RepositoryUtils.getWorkspace();
        LinkedList<DeploymentProjectItem> result = new LinkedList<DeploymentProjectItem>();
        List<AbstractTreeNode> nodes = this.repositoryTreeState.getDeploymentRepository().getChildNodes();
        for (AbstractTreeNode node : nodes) {
            UserWorkspaceDeploymentProject deploymentProject;
            ProjectArtefact artefact = node.getDataBean();
            if (!(artefact instanceof UserWorkspaceDeploymentProject) || (deploymentProject = (UserWorkspaceDeploymentProject)artefact).isDeleted()) continue;
            UserWorkspaceDeploymentProject latestDeploymentVersion = deploymentProject;
            if (deploymentProject.isOpenedOtherVersion()) {
                try {
                    latestDeploymentVersion = workspace.getDesignTimeRepository().getDDProject(deploymentProject.getName());
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Failed to get latest version for deployment project '" + deploymentProject.getName() + "'"), (Throwable)e);
                }
            }
            ProjectDescriptor projectDescriptor = null;
            Collection descriptors = latestDeploymentVersion.getProjectDescriptors();
            for (ProjectDescriptor descr : descriptors) {
                if (!projectName.equals(descr.getProjectName())) continue;
                projectDescriptor = descr;
                break;
            }
            if (projectDescriptor == null) continue;
            DeploymentProjectItem item = new DeploymentProjectItem();
            item.setName(deploymentProject.getName());
            CommonVersionImpl descrVersion = new CommonVersionImpl(projectDescriptor.getProjectVersion());
            int cmp = descrVersion.compareTo((CommonVersion)project.getVersion());
            if (cmp == 0) {
                item.setDisabled(true);
                item.setMessages("Up to date");
            } else if (cmp < 0) {
                if (deploymentProject.isCheckedOut()) {
                    item.setDisabled(true);
                    item.setMessages("Checked-out");
                    item.setStyleForMessages("text-warning");
                    item.setStyleForName("text-warning");
                } else if (deploymentProject.isLocked()) {
                    item.setDisabled(true);
                    item.setMessages("Locked by other user");
                    item.setStyleForMessages("text-warning");
                    item.setStyleForName("text-warning");
                } else {
                    DependencyChecker checker = new DependencyChecker();
                    checker.addProjects((DeploymentDescriptorProject)latestDeploymentVersion);
                    checker.addProject((Project)project);
                    if (checker.check()) {
                        item.setMessages("Can be updated to " + project.getVersion().getVersionName() + " from " + descrVersion.getVersionName());
                    } else {
                        item.setMessages("Has dependency conflict!");
                        item.setStyleForMessages("text-error");
                    }
                }
            } else {
                item.setDisabled(true);
                item.setMessages("Deployment uses newer version " + descrVersion.getVersionName());
            }
            result.add(item);
        }
        if (!workspace.hasDDProject(projectName)) {
            DeploymentProjectItem item = new DeploymentProjectItem();
            item.setName(projectName);
            item.setMessages("Create deployment project");
            item.setStyleForName("text-warning");
            result.add(0, item);
        }
        return result;
    }

    private UserWorkspaceProject getSelectedProject() {
        ProjectArtefact artefact = this.repositoryTreeState.getSelectedNode().getDataBean();
        if (artefact instanceof UserWorkspaceProject) {
            return (UserWorkspaceProject)artefact;
        }
        return null;
    }

    public String redeploy() {
        UserWorkspaceProject project = this.getSelectedProject();
        if (project == null) {
            return "failure";
        }
        LinkedList<UserWorkspaceDeploymentProject> successfulyUpdated = new LinkedList<UserWorkspaceDeploymentProject>();
        for (DeploymentProjectItem item : this.items) {
            UserWorkspaceDeploymentProject deploymentProject;
            if (!item.isSelected() || (deploymentProject = this.update(item.getName(), project)) == null) continue;
            successfulyUpdated.add(deploymentProject);
        }
        for (UserWorkspaceDeploymentProject deploymentProject : successfulyUpdated) {
            try {
                DeployID id = this.deploymentManager.deploy(deploymentProject);
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "Project '" + project.getName() + "' successfully deployed with id: " + id.getName(), null));
            }
            catch (Exception e) {
                String msg = "Failed to deploy '" + project.getName() + "'";
                LOG.error((Object)msg, (Throwable)e);
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, e.getMessage()));
            }
        }
        return "success";
    }

    public void setDeploymentManager(DeploymentManager deploymentManager) {
        this.deploymentManager = deploymentManager;
    }

    public void setRepositoryTreeState(RepositoryTreeState repositoryTreeState) {
        this.repositoryTreeState = repositoryTreeState;
    }

    private UserWorkspaceDeploymentProject update(String deploymentName, UserWorkspaceProject project) {
        UserWorkspace workspace = RepositoryUtils.getWorkspace();
        try {
            UserWorkspaceDeploymentProject deploymentProject;
            if (deploymentName.equals(project.getName()) && !workspace.hasDDProject(deploymentName)) {
                workspace.createDDProject(deploymentName);
                this.repositoryTreeState.invalidateTree();
            }
            if ((deploymentProject = workspace.getDDProject(deploymentName)).isLocked()) {
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN, "Deployment project '" + deploymentName + "' is locked by other user", null));
                return null;
            }
            deploymentProject.checkOut();
            deploymentProject.addProjectDescriptor(project.getName(), (CommonVersion)project.getVersion());
            deploymentProject.checkIn();
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "Deployment project '" + deploymentName + "' successfully updated", null));
            return deploymentProject;
        }
        catch (ProjectException e) {
            String msg = "Failed to update deployment project '" + deploymentName + "'";
            LOG.error((Object)msg, (Throwable)e);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null));
            return null;
        }
    }
}

