/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.repository.diff;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.faces.model.SelectItem;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.openl.rules.diff.differs.ProjectionDiffer;
import org.openl.rules.diff.hierarchy.Projection;
import org.openl.rules.diff.test.AbstractProjection;
import org.openl.rules.diff.test.DiffTreeBuilderImpl;
import org.openl.rules.diff.test.ProjectionDifferImpl;
import org.openl.rules.diff.tree.DiffTreeNode;
import org.openl.rules.diff.xls.XlsProjectionBuilder;
import org.openl.rules.lang.xls.XlsHelper;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.repository.CommonVersionImpl;
import org.openl.rules.webstudio.web.diff.AbstractDiffController;
import org.openl.rules.webstudio.web.repository.RepositoryTreeState;
import org.openl.rules.workspace.abstracts.ArtefactPath;
import org.openl.rules.workspace.abstracts.Project;
import org.openl.rules.workspace.abstracts.ProjectArtefact;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.abstracts.ProjectFolder;
import org.openl.rules.workspace.abstracts.ProjectResource;
import org.openl.rules.workspace.abstracts.ProjectVersion;
import org.openl.rules.workspace.abstracts.impl.ArtefactPathImpl;
import org.openl.rules.workspace.dtr.DesignTimeRepository;
import org.openl.rules.workspace.lw.LocalProjectArtefact;
import org.openl.rules.workspace.uw.UserWorkspaceProjectArtefact;
import org.openl.util.FileTypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryDiffController
extends AbstractDiffController {
    private DesignTimeRepository designTimeRepository;
    private RepositoryTreeState repositoryTreeState;
    private Project projectUW;
    private Project projectRepo;
    private List<ProjectArtefact> excelArtefactsUW;
    private List<ProjectArtefact> excelArtefactsRepo;
    private String selectedExcelFileUW;
    private String selectedExcelFileRepo;
    private String selectedVersionRepo = "0.0.0";
    private static final char SEPARATOR = '/';

    public void setSelectedExcelFileUW(String selectedExcelFileUW) {
        this.selectedExcelFileUW = selectedExcelFileUW;
    }

    public String getSelectedExcelFileUW() {
        return this.selectedExcelFileUW;
    }

    public void setSelectedExcelFileRepo(String selectedExcelFileRepo) {
        this.selectedExcelFileRepo = selectedExcelFileRepo;
    }

    public String getSelectedExcelFileRepo() {
        return this.selectedExcelFileRepo;
    }

    public void setSelectedVersionRepo(String selectedVersionRepo) {
        this.selectedVersionRepo = selectedVersionRepo;
    }

    public String getSelectedVersionRepo() {
        return this.selectedVersionRepo;
    }

    public SelectItem[] getVersionsRepo() {
        UserWorkspaceProjectArtefact projectArtefact = (UserWorkspaceProjectArtefact)this.projectUW;
        Collection versions = projectArtefact.getVersions();
        SelectItem[] selectItems = new SelectItem[versions.size()];
        int i = 0;
        for (ProjectVersion version : versions) {
            selectItems[i] = new SelectItem((Object)(version.getMajor() + "." + version.getMinor() + "." + version.getRevision()));
            ++i;
        }
        return selectItems;
    }

    public List<SelectItem> getExcelFilesUW() {
        this.init();
        ArrayList<SelectItem> excelItems = new ArrayList<SelectItem>();
        for (ProjectArtefact excelArtefact : this.excelArtefactsUW) {
            excelItems.add(new SelectItem((Object)excelArtefact.getArtefactPath().getStringValue(), excelArtefact.getName()));
        }
        return excelItems;
    }

    public List<SelectItem> getExcelFilesRepo() {
        ArrayList<SelectItem> excelItems = new ArrayList<SelectItem>();
        for (ProjectArtefact excelArtefact : this.excelArtefactsRepo) {
            excelItems.add(new SelectItem((Object)excelArtefact.getArtefactPath().getStringValue(), excelArtefact.getName()));
        }
        return excelItems;
    }

    public void setDesignTimeRepository(DesignTimeRepository designTimeRepository) {
        this.designTimeRepository = designTimeRepository;
    }

    public void setRepositoryTreeState(RepositoryTreeState repositoryTreeState) {
        this.repositoryTreeState = repositoryTreeState;
    }

    public String init() {
        this.initProjectUW();
        this.initProjectRepo();
        return null;
    }

    public void initProjectUW() {
        try {
            this.projectUW = this.repositoryTreeState.getSelectedProject();
            this.excelArtefactsUW = this.getExcelArtefacts(this.projectUW, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initProjectRepo() {
        try {
            this.projectRepo = this.designTimeRepository.getProject(this.projectUW.getName(), (CommonVersion)new CommonVersionImpl(this.selectedVersionRepo));
            this.excelArtefactsRepo = this.getExcelArtefacts(this.projectRepo, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<ProjectArtefact> getExcelArtefacts(Project project, String rootPath) throws Exception {
        ArrayList<ProjectArtefact> excelArtefacts = new ArrayList<ProjectArtefact>();
        Collection projectArtefacts = null;
        if (rootPath != null) {
            try {
                projectArtefacts = this.getProjectFolder(project, rootPath).getArtefacts();
            }
            catch (Exception e) {
                return excelArtefacts;
            }
        } else {
            projectArtefacts = project.getArtefacts();
        }
        for (ProjectArtefact projectArtefact : projectArtefacts) {
            String artefactPath = projectArtefact.getArtefactPath().getStringValue();
            if (projectArtefact.isFolder()) {
                excelArtefacts.addAll(this.getExcelArtefacts(project, projectArtefact.getArtefactPath().getStringValue()));
                continue;
            }
            if (!FileTypeHelper.isExcelFile((String)artefactPath)) continue;
            excelArtefacts.add(projectArtefact);
        }
        return excelArtefacts;
    }

    private ProjectFolder getProjectFolder(Project project, String path) throws ProjectException {
        if ((path = this.removeProjectName(path)).length() == 0) {
            return project;
        }
        ProjectFolder projectFolder = (ProjectFolder)project.getArtefactByPath((ArtefactPath)new ArtefactPathImpl(path));
        return projectFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadExelFile(ProjectArtefact excelArtefact) {
        File tempFile;
        block8: {
            if (excelArtefact == null) {
                return null;
            }
            InputStream in = null;
            try {
                in = ((ProjectResource)excelArtefact).getContent();
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
            tempFile = null;
            FileOutputStream out = null;
            String filePrefix = (excelArtefact instanceof LocalProjectArtefact ? "uw" : this.selectedVersionRepo) + "_";
            try {
                tempFile = new File(filePrefix + excelArtefact.getName());
                out = new FileOutputStream(tempFile);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                IOUtils.closeQuietly((OutputStream)out);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block8;
            }
            finally {
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly((InputStream)in);
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        return tempFile;
    }

    private String removeProjectName(String path) {
        path = path.substring(path.indexOf(47, 1) + 1);
        return path;
    }

    private ProjectArtefact getExcelArtefactByPath(List<ProjectArtefact> excelArtefacts, String path) {
        for (ProjectArtefact excelArtefact : excelArtefacts) {
            if (!excelArtefact.getArtefactPath().getStringValue().equals(path)) continue;
            return excelArtefact;
        }
        return null;
    }

    @Override
    public String compare() {
        if (StringUtils.isEmpty((String)this.selectedExcelFileUW) || StringUtils.isEmpty((String)this.selectedExcelFileRepo)) {
            System.err.println("exit");
            return null;
        }
        ProjectArtefact excelArtefact1 = this.getExcelArtefactByPath(this.excelArtefactsUW, this.selectedExcelFileUW);
        File excelFile1 = this.downloadExelFile(excelArtefact1);
        XlsMetaInfo xmi1 = XlsHelper.getXlsMetaInfo((String)excelFile1.getName());
        AbstractProjection p1 = XlsProjectionBuilder.build((XlsMetaInfo)xmi1, (String)"xls1");
        excelFile1.delete();
        ProjectArtefact excelArtefact2 = this.getExcelArtefactByPath(this.excelArtefactsRepo, this.selectedExcelFileRepo);
        File excelFile2 = this.downloadExelFile(excelArtefact2);
        XlsMetaInfo xmi2 = XlsHelper.getXlsMetaInfo((String)excelFile2.getName());
        AbstractProjection p2 = XlsProjectionBuilder.build((XlsMetaInfo)xmi2, (String)"xls2");
        excelFile2.delete();
        DiffTreeBuilderImpl builder = new DiffTreeBuilderImpl();
        builder.setProjectionDiffer((ProjectionDiffer)new ProjectionDifferImpl());
        DiffTreeNode diffTree = builder.compare((Projection)p1, (Projection)p2);
        this.setDiffTree(diffTree);
        return null;
    }
}

