/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.repository.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openl.rules.webstudio.web.repository.DependencyBean;
import org.openl.rules.webstudio.web.repository.RepositoryUtils;
import org.openl.rules.workspace.abstracts.ProjectArtefact;
import org.openl.rules.workspace.abstracts.ProjectVersion;
import org.openl.rules.workspace.uw.UserWorkspaceProject;
import org.openl.rules.workspace.uw.UserWorkspaceProjectArtefact;
import org.richfaces.model.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeNode
implements TreeNode {
    private static final long serialVersionUID = 1238954077308840345L;
    private static final transient Map EMPTY = new LinkedHashMap();
    private String id;
    private String name;
    private TreeNode parent;
    private Map<Object, AbstractTreeNode> elements;
    private boolean isLeafOnly;
    private ProjectArtefact dataBean;

    public AbstractTreeNode(String id, String name) {
        this(id, name, false);
    }

    public AbstractTreeNode(String id, String name, boolean isLeafOnly) {
        this.id = id;
        this.name = name;
        this.isLeafOnly = isLeafOnly;
        if (!isLeafOnly) {
            this.elements = new LinkedHashMap<Object, AbstractTreeNode>();
        }
    }

    public AbstractTreeNode add(AbstractTreeNode child) {
        this.addChild(child.getId(), child);
        return this;
    }

    public void addChild(Object id, TreeNode child) {
        this.checkLeafOnly();
        this.elements.put(id, (AbstractTreeNode)child);
        child.setParent((TreeNode)this);
    }

    private void checkLeafOnly() {
        if (this.isLeafOnly) {
            throw new UnsupportedOperationException("cannot have children");
        }
    }

    protected void clear() {
        if (this.elements != null) {
            for (AbstractTreeNode child : this.elements.values()) {
                child.clear();
            }
            this.elements.clear();
        }
    }

    public TreeNode getChild(Object id) {
        this.checkLeafOnly();
        return this.elements.get(id);
    }

    public List<AbstractTreeNode> getChildNodes() {
        ArrayList<AbstractTreeNode> list = new ArrayList<AbstractTreeNode>(this.elements.values());
        return list;
    }

    public Iterator getChildren() {
        Iterator<Map.Entry<Object, AbstractTreeNode>> result;
        if (this.isLeafOnly) {
            this.checkLeafOnly();
            result = EMPTY.entrySet().iterator();
        } else {
            result = this.elements.entrySet().iterator();
        }
        return result;
    }

    public Object getData() {
        return this;
    }

    public ProjectArtefact getDataBean() {
        return this.dataBean;
    }

    public List<DependencyBean> getDependencies() {
        return null;
    }

    public abstract String getIcon();

    public abstract String getIconLeaf();

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public abstract String getType();

    public String getVersionName() {
        if (this.dataBean instanceof UserWorkspaceProject) {
            ProjectVersion version = ((UserWorkspaceProject)this.dataBean).getVersion();
            return version == null ? null : version.getVersionName();
        }
        return null;
    }

    public Collection<ProjectVersion> getVersions() {
        if (this.dataBean instanceof UserWorkspaceProjectArtefact) {
            UserWorkspaceProjectArtefact uwpa = (UserWorkspaceProjectArtefact)this.dataBean;
            LinkedList<ProjectVersion> result = new LinkedList<ProjectVersion>(uwpa.getVersions());
            Collections.sort(result, RepositoryUtils.VERSIONS_REVERSE_COMPARATOR);
            return result;
        }
        return new LinkedList<ProjectVersion>();
    }

    public boolean isLeaf() {
        boolean result = this.isLeafOnly ? true : this.elements.isEmpty();
        return result;
    }

    public void removeChild(Object id) {
        this.checkLeafOnly();
        this.elements.remove(id);
    }

    public void setData(Object data) {
    }

    public void setDataBean(ProjectArtefact dataBean) {
        this.dataBean = dataBean;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }
}

