/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.repository.tree;

import java.util.Date;
import org.openl.rules.webstudio.web.repository.tree.TreeFile;
import org.openl.rules.webstudio.web.repository.tree.TreeProject;
import org.openl.rules.workspace.abstracts.Project;
import org.openl.rules.workspace.abstracts.ProjectVersion;
import org.openl.rules.workspace.abstracts.VersionInfo;
import org.openl.rules.workspace.uw.UserWorkspaceDeploymentProject;

public class TreeDProject
extends TreeFile {
    private static final long serialVersionUID = -1058464776132912419L;

    public TreeDProject(String id, String name) {
        super(id, name);
    }

    public String getComments() {
        return TreeProject.generateComments(this.getDataBean());
    }

    public Date getCreatedAt() {
        ProjectVersion projectVersion = this.getProject().getVersion();
        if (projectVersion == null) {
            return null;
        }
        VersionInfo vi = projectVersion.getVersionInfo();
        return vi != null ? vi.getCreatedAt() : null;
    }

    public String getCreatedBy() {
        ProjectVersion projectVersion = this.getProject().getVersion();
        if (projectVersion == null) {
            return null;
        }
        VersionInfo vi = projectVersion.getVersionInfo();
        return vi != null ? vi.getCreatedBy() : null;
    }

    public String getIconLeaf() {
        UserWorkspaceDeploymentProject project = (UserWorkspaceDeploymentProject)this.getDataBean();
        if (project.isLocalOnly()) {
            return "/webresource/images/repository/local.gif";
        }
        if (project.isDeleted()) {
            return "/webresource/images/repository/deleted.gif";
        }
        if (project.isCheckedOut()) {
            return "/webresource/images/repository/checkedout.gif";
        }
        boolean isLocked = project.isLocked();
        if (project.isOpened()) {
            if (isLocked) {
                return "/webresource/images/repository/opened-locked.gif";
            }
            return "/webresource/images/repository/opened.gif";
        }
        if (isLocked) {
            return "/webresource/images/repository/closed-locked.gif";
        }
        return "/webresource/images/repository/closed.gif";
    }

    private Project getProject() {
        return (Project)this.getDataBean();
    }

    public String getStatus() {
        return TreeProject.generateStatus(this.getDataBean());
    }

    public String getType() {
        return "deployment";
    }

    public String getVersion() {
        ProjectVersion projectVersion = this.getProject().getVersion();
        if (projectVersion == null) {
            return "unversioned";
        }
        return projectVersion.getVersionName();
    }
}

