/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.repository.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.openl.rules.webstudio.web.repository.DependencyBean;
import org.openl.rules.webstudio.web.repository.tree.TreeFolder;
import org.openl.rules.workspace.abstracts.Project;
import org.openl.rules.workspace.abstracts.ProjectArtefact;
import org.openl.rules.workspace.abstracts.ProjectDependency;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.abstracts.ProjectVersion;
import org.openl.rules.workspace.abstracts.VersionInfo;
import org.openl.rules.workspace.dtr.LockInfo;
import org.openl.rules.workspace.uw.UserWorkspaceProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeProject
extends TreeFolder {
    private static final long serialVersionUID = -326805891782640894L;
    private List<DependencyBean> dependencies;

    protected static String generateComments(ProjectArtefact artefact) {
        LockInfo lock;
        if (artefact == null || !(artefact instanceof UserWorkspaceProject)) {
            return null;
        }
        UserWorkspaceProject userProject = (UserWorkspaceProject)artefact;
        if (userProject.isLocalOnly()) {
            return "Local";
        }
        if (userProject.isDeleted()) {
            return "Deleted";
        }
        if (userProject.isCheckedOut()) {
            return null;
        }
        if (userProject.isOpened()) {
            ProjectVersion activeVersion = userProject.getVersion();
            if (activeVersion != null && userProject.isOpenedOtherVersion()) {
                return "Version " + activeVersion.getVersionName();
            }
            return null;
        }
        if (userProject.isLocked() && (lock = userProject.getLockInfo()) != null) {
            return "Locked by " + lock.getLockedBy().getUserName();
        }
        return null;
    }

    protected static String generateStatus(ProjectArtefact artefact) {
        if (artefact == null || !(artefact instanceof UserWorkspaceProject)) {
            return null;
        }
        UserWorkspaceProject userProject = (UserWorkspaceProject)artefact;
        if (userProject.isLocalOnly()) {
            return "Local";
        }
        if (userProject.isDeleted()) {
            return "Deleted";
        }
        if (userProject.isCheckedOut()) {
            return "Checked-out";
        }
        StringBuilder status = new StringBuilder();
        if (userProject.isOpened()) {
            if (userProject.isOpenedOtherVersion()) {
                status.append("Opened Old Version");
            } else {
                status.append("Opened");
            }
        } else {
            status.append("Closed");
        }
        if (userProject.isLocked()) {
            status.append(" - Locked");
        }
        return status.toString();
    }

    public TreeProject(String id, String name) {
        super(id, name);
    }

    public synchronized boolean addDependency(ProjectDependency dep) throws ProjectException {
        Collection dependencies = this.getProject().getDependencies();
        if (dependencies.contains(dep)) {
            return false;
        }
        ArrayList<ProjectDependency> newDeps = new ArrayList<ProjectDependency>(dependencies);
        newDeps.add(dep);
        ((Project)this.getDataBean()).setDependencies(newDeps);
        this.dependencies = null;
        return true;
    }

    public String getComments() {
        return TreeProject.generateComments(this.getDataBean());
    }

    public Date getCreatedAt() {
        ProjectVersion projectVersion = this.getProject().getVersion();
        if (projectVersion == null) {
            return null;
        }
        VersionInfo vi = projectVersion.getVersionInfo();
        return vi != null ? vi.getCreatedAt() : null;
    }

    public String getCreatedBy() {
        ProjectVersion projectVersion = this.getProject().getVersion();
        if (projectVersion == null) {
            return null;
        }
        VersionInfo vi = projectVersion.getVersionInfo();
        return vi != null ? vi.getCreatedBy() : null;
    }

    @Override
    public synchronized List<DependencyBean> getDependencies() {
        if (this.dependencies == null) {
            Collection deps = this.getProject().getDependencies();
            this.dependencies = new ArrayList<DependencyBean>(deps.size());
            for (ProjectDependency pd : deps) {
                DependencyBean depBean = new DependencyBean();
                depBean.setProjectName(pd.getProjectName());
                depBean.setLowerVersion(pd.getLowerLimit().getVersionName());
                if (pd.hasUpperLimit()) {
                    depBean.setUpperVersion(pd.getUpperLimit().getVersionName());
                }
                this.dependencies.add(depBean);
            }
        }
        return this.dependencies;
    }

    @Override
    public String getIcon() {
        UserWorkspaceProject project = (UserWorkspaceProject)this.getDataBean();
        if (project.isLocalOnly()) {
            return "/webresource/images/repository/local.gif";
        }
        if (project.isDeleted()) {
            return "/webresource/images/repository/deleted.gif";
        }
        if (project.isCheckedOut()) {
            return "/webresource/images/repository/checkedout.gif";
        }
        boolean isLocked = project.isLocked();
        if (project.isOpened()) {
            if (isLocked) {
                return "/webresource/images/repository/opened-locked.gif";
            }
            return "/webresource/images/repository/opened.gif";
        }
        if (isLocked) {
            return "/webresource/images/repository/closed-locked.gif";
        }
        return "/webresource/images/repository/closed.gif";
    }

    private Project getProject() {
        return (Project)this.getDataBean();
    }

    public String getStatus() {
        return TreeProject.generateStatus(this.getDataBean());
    }

    @Override
    public String getType() {
        return "project";
    }

    public String getVersion() {
        ProjectVersion projectVersion = this.getProject().getVersion();
        if (projectVersion == null) {
            return "unversioned";
        }
        return projectVersion.getVersionName();
    }

    public synchronized void removeDependency(String dependency) throws ProjectException {
        Collection dependencies = this.getProject().getDependencies();
        ArrayList<ProjectDependency> newDeps = new ArrayList<ProjectDependency>();
        boolean changed = false;
        for (ProjectDependency d : dependencies) {
            if (d.getProjectName().equals(dependency)) {
                changed = true;
                continue;
            }
            newDeps.add(d);
        }
        if (changed) {
            this.dependencies = null;
            this.getProject().setDependencies(newDeps);
        }
    }
}

