/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.repository.upload;

import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.webstudio.util.NameChecker;
import org.openl.rules.webstudio.web.repository.FileProjectResource;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.abstracts.ProjectResource;
import org.openl.rules.workspace.abstracts.impl.ArtefactPathImpl;
import org.openl.rules.workspace.uw.UserWorkspace;
import org.openl.rules.workspace.uw.UserWorkspaceProject;
import org.openl.rules.workspace.uw.UserWorkspaceProjectFolder;

public class RulesProjectBuilder {
    private static final Log LOG = LogFactory.getLog(RulesProjectBuilder.class);
    private final UserWorkspaceProject project;

    public RulesProjectBuilder(UserWorkspace workspace, String projectName) throws ProjectException {
        workspace.createProject(projectName);
        this.project = (UserWorkspaceProject)workspace.getProject(projectName);
        this.project.checkOut();
    }

    public boolean addFile(String fileName, InputStream inputStream) throws ProjectException {
        String resName;
        UserWorkspaceProject folder = this.project;
        int pos = fileName.lastIndexOf(47);
        if (pos >= 0) {
            String path = fileName.substring(0, pos);
            resName = fileName.substring(pos + 1);
            folder = this.checkPath(this.project, path);
        } else {
            resName = fileName;
        }
        this.checkName(resName);
        FileProjectResource projectResource = new FileProjectResource(inputStream);
        folder.addResource(resName, (ProjectResource)projectResource);
        return true;
    }

    public boolean addFolder(String folderName) throws ProjectException {
        folderName = folderName.substring(0, folderName.length() - 1);
        this.checkPath(this.project, folderName);
        return true;
    }

    public void cancel() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Canceling uploading of new project");
            }
            this.project.close();
            this.project.delete();
            this.project.erase();
        }
        catch (ProjectException e) {
            LOG.error((Object)"Failed to cancel new project", (Throwable)e);
        }
    }

    public void checkIn() throws ProjectException {
        this.project.checkIn();
    }

    private void checkName(String artefactName) throws ProjectException {
        if (!NameChecker.checkName(artefactName)) {
            throw new ProjectException("File or folder name '" + artefactName + "' is invalid. " + NameChecker.BAD_NAME_MSG);
        }
    }

    private UserWorkspaceProjectFolder checkPath(UserWorkspaceProject project, String fullName) throws ProjectException {
        ArtefactPathImpl ap = new ArtefactPathImpl(fullName);
        UserWorkspaceProject current = project;
        for (String segment : ap.getSegments()) {
            if (current.hasArtefact(segment)) {
                current = (UserWorkspaceProjectFolder)current.getArtefact(segment);
                continue;
            }
            this.checkName(segment);
            current = current.addFolder(segment);
        }
        return current;
    }
}

