/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.repository.upload;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.webstudio.web.repository.upload.AProjectCreator;
import org.openl.rules.webstudio.web.repository.upload.RootFolderExtractor;
import org.openl.rules.webstudio.web.repository.upload.RulesProjectBuilder;
import org.openl.rules.webstudio.web.repository.upload.ZipRulesProjectBuilder;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.filter.PathFilter;
import org.openl.rules.workspace.uw.UserWorkspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFileProjectCreator
extends AProjectCreator {
    private static final Log LOG = LogFactory.getLog(ZipFileProjectCreator.class);
    private ZipFile zipFile;
    private PathFilter zipFilter;

    public ZipFileProjectCreator(File uploadedFile, String projectName, UserWorkspace userWorkspace, PathFilter zipFilter) throws ZipException, IOException {
        super(projectName, userWorkspace);
        this.zipFile = new ZipFile(uploadedFile);
        this.zipFilter = zipFilter;
    }

    @Override
    public String createRulesProject() {
        String errorMessage = null;
        RulesProjectBuilder projectBuilder = null;
        try {
            Set<String> sortedNames = this.sortZipEntriesNames(this.zipFile);
            projectBuilder = this.getProjectBuilder(sortedNames);
            for (String name : sortedNames) {
                ZipEntry item = this.zipFile.getEntry(name);
                if (item.isDirectory()) {
                    ((ZipRulesProjectBuilder)projectBuilder).addFolder(item.getName());
                    continue;
                }
                InputStream zipInputStream = this.zipFile.getInputStream(item);
                ((ZipRulesProjectBuilder)projectBuilder).addFile(item.getName(), zipInputStream);
            }
            projectBuilder.checkIn();
        }
        catch (Exception e) {
            if (projectBuilder != null) {
                projectBuilder.cancel();
            }
            LOG.error((Object)"Error creating project.", (Throwable)e);
            errorMessage = e.getMessage();
        }
        return errorMessage;
    }

    private ZipRulesProjectBuilder getProjectBuilder(Set<String> sortedNames) throws ProjectException {
        RootFolderExtractor folderExtractor = new RootFolderExtractor(sortedNames);
        return new ZipRulesProjectBuilder(this.getUserWorkspace(), this.getProjectName(), this.zipFilter, folderExtractor);
    }

    private Set<String> sortZipEntriesNames(ZipFile zipFile) {
        TreeSet<String> sortedNames = new TreeSet<String>();
        Enumeration<? extends ZipEntry> items = zipFile.entries();
        while (items.hasMoreElements()) {
            ZipEntry item = items.nextElement();
            sortedNames.add(item.getName());
        }
        return sortedNames;
    }
}

