/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.repository.upload;

import java.io.InputStream;
import org.openl.rules.webstudio.web.repository.upload.RootFolderExtractor;
import org.openl.rules.webstudio.web.repository.upload.RulesProjectBuilder;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.filter.PathFilter;
import org.openl.rules.workspace.uw.UserWorkspace;

public class ZipRulesProjectBuilder
extends RulesProjectBuilder {
    private final PathFilter filter;
    private final RootFolderExtractor folderExtractor;

    public ZipRulesProjectBuilder(UserWorkspace workspace, String projectName, PathFilter filter, RootFolderExtractor folderExtractor) throws ProjectException {
        super(workspace, projectName);
        this.filter = filter;
        this.folderExtractor = folderExtractor;
    }

    public boolean addFile(String fileName, InputStream inputStream) throws ProjectException {
        String filteredFileName = this.folderExtractor.extractFromRootFolder(fileName);
        if (filteredFileName != null) {
            if (this.filter != null && !this.filter.accept(filteredFileName)) {
                return false;
            }
            return super.addFile(filteredFileName, inputStream);
        }
        return false;
    }

    public boolean addFolder(String folderName) throws ProjectException {
        String filteredFolderName = this.folderExtractor.extractFromRootFolder(folderName);
        if (filteredFolderName != null) {
            if (!this.filter.accept(filteredFolderName)) {
                return false;
            }
            return super.addFolder(filteredFolderName);
        }
        return false;
    }
}

