/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.search;

import org.ajax4jsf.component.UIRepeat;
import org.apache.commons.lang.StringUtils;
import org.openl.rules.indexer.Index;
import org.openl.rules.ui.ProjectIndexer;
import org.openl.rules.ui.ProjectModel;
import org.openl.rules.webstudio.web.search.SimpleSearchBean;
import org.openl.rules.webstudio.web.util.WebStudioUtils;

public class IndexSearchBean
extends SimpleSearchBean {
    private static final int SEARCH_RESULT_COLUMNS_COUNT = 3;
    private UIRepeat searchLetters;

    public UIRepeat getSearchLetters() {
        return this.searchLetters;
    }

    public void setSearchLetters(UIRepeat searchLetters) {
        this.searchLetters = searchLetters;
    }

    public String[] getIndexLetters() {
        ProjectModel model = WebStudioUtils.getProjectModel();
        ProjectIndexer indexer = model.getIndexer();
        if (indexer != null) {
            return indexer.getLetters();
        }
        return new String[0];
    }

    public Index.TokenBucket[] getIndexTokens() {
        if (this.isReady()) {
            ProjectModel model = WebStudioUtils.getProjectModel();
            String letter = (String)this.searchLetters.getRowData();
            ProjectIndexer indexer = model.getIndexer();
            if (indexer != null) {
                return indexer.getBuckets(letter);
            }
        }
        return new Index.TokenBucket[0];
    }

    public int getColumnsCount() {
        return 3;
    }

    public Index.TokenBucket[][] getOrderedIndexTokens() {
        Index.TokenBucket[] tokens = this.getIndexTokens();
        if (tokens.length == 12) {
            System.out.println();
        }
        int rows = this.roundUp(Double.valueOf(tokens.length) / 3.0);
        Index.TokenBucket[][] result = new Index.TokenBucket[rows][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < rows; ++j) {
                Index.TokenBucket element;
                int index = i * rows + j;
                if (index >= tokens.length) continue;
                result[j][i] = element = tokens[index];
            }
        }
        return result;
    }

    public String search() {
        ProjectIndexer projectIndexer;
        ProjectModel projectModel;
        String[][] searchResults = new String[][]{};
        if (StringUtils.isNotBlank((String)this.getSearchQuery()) && (projectModel = WebStudioUtils.getProjectModel()) != null && (projectIndexer = projectModel.getIndexer()) != null) {
            searchResults = projectIndexer.getResultsForIndex(this.getSearchQuery());
        }
        this.setSearchResults(searchResults);
        return null;
    }

    public boolean isReady() {
        ProjectModel model = WebStudioUtils.getProjectModel();
        return model.isProjectCompiledSuccessfully();
    }

    private int roundUp(double value) {
        int result = Double.valueOf(value).intValue();
        if ((double)result < value) {
            ++result;
        }
        return result;
    }
}

