/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.search;

import org.apache.commons.lang.StringUtils;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.rules.ui.ProjectIndexer;
import org.openl.rules.ui.ProjectModel;
import org.openl.rules.webstudio.web.util.WebStudioUtils;

public class SimpleSearchBean {
    private String searchQuery;
    private String[][] searchResults;

    public SimpleSearchBean() {
        this.initSearchQuery();
        if (StringUtils.isNotBlank((String)this.searchQuery)) {
            this.search();
        }
    }

    public String getSearchQuery() {
        return this.searchQuery;
    }

    public void setSearchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
    }

    public String[][] getSearchResults() {
        return this.searchResults;
    }

    public void setSearchResults(String[][] searchResults) {
        this.searchResults = searchResults;
    }

    private void initSearchQuery() {
        String searchQuery = FacesUtils.getRequestParameter((String)"searchQuery");
        if (StringUtils.isNotBlank((String)searchQuery)) {
            String spaceToRemove = Character.toString('\u00a0');
            searchQuery = searchQuery.replaceAll(spaceToRemove, " ");
            this.setSearchQuery(searchQuery);
        }
    }

    public String search() {
        ProjectIndexer projectIndexer;
        ProjectModel projectModel;
        String[][] searchResults = new String[][]{};
        if (StringUtils.isNotBlank((String)this.searchQuery) && (projectModel = WebStudioUtils.getProjectModel()) != null && (projectIndexer = projectModel.getIndexer()) != null) {
            searchResults = projectModel.getIndexer().getResultsForQuery(this.searchQuery, 200, null);
        }
        this.setSearchResults(searchResults);
        return null;
    }
}

