/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.servlet;

import org.acegisecurity.userdetails.UserDetails;
import org.openl.rules.workspace.MultiUserWorkspaceManager;
import org.openl.rules.workspace.WorkspaceException;
import org.openl.rules.workspace.WorkspaceUser;
import org.openl.rules.workspace.WorkspaceUserImpl;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.deploy.DeploymentException;
import org.openl.rules.workspace.deploy.ProductionDeployer;
import org.openl.rules.workspace.deploy.ProductionDeployerManager;
import org.openl.rules.workspace.deploy.impl.ProductionDeployerManagerImpl;
import org.openl.rules.workspace.uw.UserWorkspace;
import org.openl.util.Log;

public class RulesUserSession {
    private UserDetails user;
    private UserWorkspace userWorkspace;
    private MultiUserWorkspaceManager workspaceManager;
    private ProductionDeployer deployer;
    private ProductionDeployerManager deployerManager = new ProductionDeployerManagerImpl();

    public synchronized ProductionDeployer getDeployer() throws DeploymentException {
        if (this.deployer == null) {
            this.deployer = this.deployerManager.getDeployer((WorkspaceUser)new WorkspaceUserImpl(this.user.getUsername()));
        }
        return this.deployer;
    }

    public String getUserName() {
        if (this.user == null) {
            return null;
        }
        return this.user.getUsername();
    }

    public synchronized UserWorkspace getUserWorkspace() throws WorkspaceException, ProjectException {
        if (this.userWorkspace == null) {
            this.userWorkspace = this.workspaceManager.getUserWorkspace((WorkspaceUser)new WorkspaceUserImpl(this.getUserName()));
            this.userWorkspace.activate();
        }
        return this.userWorkspace;
    }

    public MultiUserWorkspaceManager getWorkspaceManager() {
        return this.workspaceManager;
    }

    public void sessionDestroyed() {
        if (this.userWorkspace != null) {
            this.userWorkspace.release();
        }
    }

    public void sessionDidActivate() {
        try {
            this.userWorkspace.activate();
        }
        catch (ProjectException e) {
            Log.error((Object)"Error at activation", (Throwable)e);
        }
    }

    public void sessionWillPassivate() {
        this.userWorkspace.passivate();
    }

    public void setUser(UserDetails user) {
        this.user = user;
    }

    public void setWorkspaceManager(MultiUserWorkspaceManager workspaceManager) {
        this.workspaceManager = workspaceManager;
    }
}

