/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.servlet;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.webstudio.web.servlet.RulesUserSession;

public class SessionListener
implements HttpSessionActivationListener,
HttpSessionListener {
    private static final Log LOG = LogFactory.getLog(SessionListener.class);

    private RulesUserSession getUserRules(HttpSession session) {
        return (RulesUserSession)session.getAttribute("rulesUserSession");
    }

    protected void printSession(HttpSession session) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("\n  id           : " + session.getId());
        sb.append("\n  creation time: " + session.getCreationTime());
        sb.append("\n  accessed time: " + session.getLastAccessedTime());
        sb.append("\n  max inactive : " + session.getMaxInactiveInterval());
        RulesUserSession obj = this.getUserRules(session);
        sb.append("\n  has rulesUserSession? " + (obj != null));
        LOG.debug((Object)sb.toString());
    }

    public void sessionCreated(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        LOG.debug((Object)("sessionCreated: " + session));
        this.printSession(session);
        RulesUserSession obj = this.getUserRules(session);
        if (obj == null) {
            LOG.debug((Object)"no rulesUserSession");
        } else {
            LOG.debug((Object)"has rulesUserSession (why?)");
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        LOG.debug((Object)("sessionDestroyed: " + session));
        this.printSession(session);
        RulesUserSession obj = this.getUserRules(session);
        if (obj == null) {
            LOG.debug((Object)"!!! no rulesUserSession");
        } else {
            LOG.debug((Object)"removing rulesUserSession");
            obj.sessionDestroyed();
            LOG.debug((Object)"session was destroyed");
        }
    }

    public void sessionDidActivate(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        LOG.debug((Object)("sessionDidActivate: " + session));
        this.printSession(session);
        RulesUserSession rulesUserSession = this.getUserRules(session);
        if (rulesUserSession != null) {
            rulesUserSession.sessionDidActivate();
        }
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        LOG.debug((Object)("sessionWillPassivate: " + session));
        this.printSession(session);
        RulesUserSession rulesUserSession = this.getUserRules(session);
        if (rulesUserSession != null) {
            rulesUserSession.sessionWillPassivate();
        }
    }
}

