/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.tableeditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.CompiledOpenClass;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.commons.web.util.WebTool;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.message.OpenLWarnMessage;
import org.openl.message.Severity;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNodeAdapter;
import org.openl.rules.service.TableServiceException;
import org.openl.rules.service.TableServiceImpl;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IOpenLTable;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.tableeditor.model.TableEditorModel;
import org.openl.rules.ui.ProjectModel;
import org.openl.rules.ui.WebStudio;
import org.openl.rules.ui.tests.results.RanTestsResults;
import org.openl.rules.ui.tests.results.Test;
import org.openl.rules.webstudio.properties.SystemValuesManager;
import org.openl.rules.webstudio.web.util.WebStudioUtils;
import org.openl.syntax.ISyntaxNode;
import org.openl.util.StringTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowTableBean {
    private static final Log LOG = LogFactory.getLog(ShowTableBean.class);
    private Test[] runnableTestMethods = new Test[0];
    private Test[] allTests = new Test[0];
    private boolean runnable;
    private List<IOpenLTable> targetTables;
    private String uri = FacesUtils.getRequestParameter((String)"uri");
    private IOpenLTable table;
    private List<OpenLMessage> errors;
    private List<OpenLMessage> warnings;
    private List<OpenLMessage> problems;
    private String notViewParams;
    private String paramsWithoutShowFormulas;
    private String paramsWithoutUri;

    public ShowTableBean() {
        WebStudio studio = WebStudioUtils.getWebStudio();
        if (this.uri == null) {
            this.uri = studio.getTableUri();
        } else {
            studio.setTableUri(this.uri);
        }
        ProjectModel model = studio.getModel();
        this.table = model.getTable(this.uri);
        this.runnable = model.isRunnable(this.uri);
        if (this.runnable) {
            this.targetTables = model.getTargetTables(this.uri);
        }
        this.initProblems();
        this.initTests(model);
        this.initParams();
    }

    private void initParams() {
        HashMap paramMap = new HashMap(FacesUtils.getRequestParameterMap());
        for (Map.Entry entry : paramMap.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            entry.setValue(new String[]{(String)entry.getValue()});
        }
        this.notViewParams = WebTool.listRequestParams(paramMap, (String[])new String[]{"transparency", "filterType", "view"});
        this.paramsWithoutUri = WebTool.listRequestParams(paramMap, (String[])new String[]{"uri", "mode"});
        this.paramsWithoutShowFormulas = WebTool.listRequestParams(paramMap, (String[])new String[]{"transparency", "filterType", "showFormulas"});
    }

    private void initTests(ProjectModel model) {
        this.initRunnableTestMethods(model);
        this.initAllTests(model);
    }

    private void initAllTests(ProjectModel model) {
        RanTestsResults allTestRunner = model.getAllTestMethods(this.uri);
        if (allTestRunner != null) {
            this.allTests = allTestRunner.getTests();
        }
    }

    private void initRunnableTestMethods(ProjectModel model) {
        RanTestsResults testsRunner = model.getTestMethods(this.uri);
        if (testsRunner != null) {
            this.runnableTestMethods = testsRunner.getTests();
        }
    }

    private void initProblems() {
        this.initErrors();
        this.initWarnings();
        this.problems = new ArrayList<OpenLMessage>();
        this.problems.addAll(this.errors);
        this.problems.addAll(this.warnings);
    }

    private void initErrors() {
        List messages = this.table.getMessages();
        this.errors = OpenLMessagesUtils.filterMessagesBySeverity((List)messages, (Severity)Severity.ERROR);
    }

    private void initWarnings() {
        this.warnings = new ArrayList<OpenLMessage>();
        if (this.targetTables != null) {
            for (IOpenLTable targetTable : this.targetTables) {
                if (targetTable.getMessages().size() <= 0) continue;
                this.warnings.add(new OpenLMessage("Tested rules have errors", ""));
                break;
            }
        }
        WebStudio studio = WebStudioUtils.getWebStudio();
        ProjectModel model = studio.getModel();
        CompiledOpenClass compiledOpenClass = model.getCompiledOpenClass();
        List messages = compiledOpenClass.getMessages();
        List warningMessages = OpenLMessagesUtils.filterMessagesBySeverity((List)messages, (Severity)Severity.WARN);
        for (OpenLMessage message : warningMessages) {
            OpenLWarnMessage warning;
            ISyntaxNode syntaxNode;
            if (!(message instanceof OpenLWarnMessage) || !((syntaxNode = (warning = (OpenLWarnMessage)message).getSource()) instanceof TableSyntaxNode) || !((TableSyntaxNode)syntaxNode).getUri().equals(this.uri)) continue;
            this.warnings.add((OpenLMessage)warning);
        }
    }

    private boolean isDispatcherValidationNode() {
        return ((TableSyntaxNodeAdapter)this.table).getNameFromHeader().startsWith("validateGapOverlap");
    }

    private boolean updateSystemValue(TableEditorModel editorModel, TablePropertyDefinition sysProperty) {
        boolean result = false;
        String systemValue = null;
        if (sysProperty.getSystemValuePolicy().equals((Object)TablePropertyDefinition.SystemValuePolicy.ON_EACH_EDIT) && (systemValue = SystemValuesManager.getInstance().getSystemValueString(sysProperty.getSystemValueDescriptor())) != null) {
            try {
                editorModel.setProperty(sysProperty.getName(), systemValue);
                result = true;
            }
            catch (Exception e) {
                LOG.error((Object)String.format("Can`t update system property '%s' with value '%s'", sysProperty.getName(), systemValue), (Throwable)e);
            }
        }
        return result;
    }

    public String getEncodedUri() {
        return StringTool.encodeURL((String)this.uri);
    }

    public String getMode() {
        return FacesUtils.getRequestParameter((String)"mode");
    }

    public String getNotViewParams() {
        return this.notViewParams;
    }

    public String getParamsWithoutUri() {
        return this.paramsWithoutUri;
    }

    public String getParamsWithoutShowFormulas() {
        return this.paramsWithoutShowFormulas;
    }

    public IOpenLTable getTable() {
        return this.table;
    }

    public List<OpenLMessage> getErrors() {
        return this.errors;
    }

    public List<OpenLMessage> getWarnings() {
        return this.warnings;
    }

    public List<OpenLMessage> getProblems() {
        return this.problems;
    }

    public TestRunsResultBean getTestRunResults() {
        RanTestsResults atr = WebStudioUtils.getProjectModel().getRunMethods(this.uri);
        Test[] tests = null;
        if (atr != null) {
            tests = atr.getTests();
        }
        return new TestRunsResultBean(tests);
    }

    public Test[] getTests() {
        return this.runnableTestMethods;
    }

    public String getUri() {
        return this.uri;
    }

    public List<IOpenLTable> getTargetTables() {
        return this.targetTables;
    }

    public String getView() {
        WebStudio studio = WebStudioUtils.getWebStudio();
        return studio.getModel().getTableView(FacesUtils.getRequestParameter((String)"view"));
    }

    public boolean isCopyable() {
        ProjectModel projectModel = WebStudioUtils.getProjectModel();
        return projectModel.isEditable() && !this.isServiceTable() && !XlsNodeTypes.XLS_DATATYPE.toString().equals(this.table.getType()) && !this.isDispatcherValidationNode();
    }

    public boolean isServiceTable() {
        String tableType = this.table.getType();
        return XlsNodeTypes.XLS_ENVIRONMENT.toString().equals(tableType) || XlsNodeTypes.XLS_OTHER.toString().equals(tableType) || XlsNodeTypes.XLS_PROPERTIES.toString().equals(tableType);
    }

    public boolean isCanCreateTest() {
        return this.table.isExecutable() && this.isEditable();
    }

    public boolean isEditable() {
        ProjectModel projectModel = WebStudioUtils.getProjectModel();
        return projectModel.isEditable() && !this.isDispatcherValidationNode();
    }

    public boolean isEditableAsNewVersion() {
        return this.isEditable() && this.table.isVersionable();
    }

    public boolean isHasErrors() {
        return CollectionUtils.isNotEmpty(this.errors);
    }

    public boolean isHasWarnings() {
        return CollectionUtils.isNotEmpty(this.warnings);
    }

    public boolean isHasProblems() {
        return this.isHasErrors() || this.isHasWarnings();
    }

    public boolean isRunnable() {
        return this.runnable;
    }

    public boolean isTestable() {
        return this.runnableTestMethods.length > 0;
    }

    public boolean isHasAnyTests() {
        return this.allTests.length > 0;
    }

    public Test[] getAllTests() {
        return this.allTests;
    }

    public void setAllTests(Test[] allTests) {
        this.allTests = allTests;
    }

    public boolean isShowFormulas() {
        String showFormulas = FacesUtils.getRequestParameter((String)"showFormulas");
        if (showFormulas != null) {
            return Boolean.parseBoolean(showFormulas);
        }
        WebStudio webStudio = WebStudioUtils.getWebStudio();
        return webStudio != null && webStudio.isShowFormulas();
    }

    public boolean isCollapseProperties() {
        String collapseProperties = FacesUtils.getRequestParameter((String)"collapseProperties");
        if (collapseProperties != null) {
            return Boolean.parseBoolean(collapseProperties);
        }
        WebStudio webStudio = WebStudioUtils.getWebStudio();
        return webStudio != null && webStudio.isCollapseProperties();
    }

    public String removeTable() {
        WebStudio studio = WebStudioUtils.getWebStudio();
        IGridTable gridTable = this.table.getGridTable("view.developer");
        try {
            new TableServiceImpl(true).removeTable(gridTable);
            studio.rebuildModel();
        }
        catch (TableServiceException e) {
            e.printStackTrace();
            return null;
        }
        return "mainPage";
    }

    public void afterSaveAction(String newUri) {
        WebStudio studio = WebStudioUtils.getWebStudio();
        studio.setTableUri(newUri);
        studio.rebuildModel();
    }

    public boolean updateSystemProperties() {
        boolean result = true;
        if (!this.isServiceTable()) {
            String editorId = FacesUtils.getRequestParameter((String)"editorId");
            Map editorModelMap = (Map)FacesUtils.getSessionParam((String)"_tableEditorModel");
            TableEditorModel editorModel = (TableEditorModel)editorModelMap.get(editorId);
            List sysProps = TablePropertyDefinitionUtils.getSystemProperties();
            for (TablePropertyDefinition sysProperty : sysProps) {
                result = this.updateSystemValue(editorModel, sysProperty);
            }
        }
        return result;
    }

    public String getTreeNodeId() {
        WebStudio studio = WebStudioUtils.getWebStudio();
        String id = studio.getModel().getTreeNodeId(this.getUri());
        return id;
    }

    public static class TestRunsResultBean {
        private Test[] tests;
        private TestProxy[] proxies;

        public TestRunsResultBean(Test[] tests) {
            this.tests = tests;
            this.proxies = tests == null ? new TestProxy[0] : new TestProxy[tests.length];
            for (int i = 0; i < this.proxies.length; ++i) {
                this.proxies[i] = new TestProxy(i);
            }
        }

        public TestProxy[] getTests() {
            return this.proxies;
        }

        public boolean isNotEmpty() {
            if (ArrayUtils.isNotEmpty((Object[])this.tests)) {
                for (TestProxy testProxy : this.getTests()) {
                    Object[] descriptions = testProxy.getDescriptions();
                    if (!ArrayUtils.isNotEmpty((Object[])descriptions)) continue;
                    return true;
                }
            }
            return false;
        }

        public class TestProxy {
            int index;

            public TestProxy(int index) {
                this.index = index;
            }

            public String[] getDescriptions() {
                Test test = this.getTest();
                String[] descriptions = new String[test.ntests()];
                for (int i = 0; i < descriptions.length; ++i) {
                    descriptions[i] = test.getTestDescription(i);
                }
                return descriptions;
            }

            private Test getTest() {
                return TestRunsResultBean.this.tests[this.index];
            }

            public String getTestName() {
                return StringTool.encodeURL((String)this.getTest().getTestName());
            }
        }
    }
}

