/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.test;

import java.util.List;
import org.ajax4jsf.component.UIRepeat;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.message.OpenLMessage;
import org.openl.meta.DoubleValue;
import org.openl.rules.testmethod.TestUnit;
import org.openl.rules.ui.ProjectModel;
import org.openl.rules.ui.tests.results.RanTestsResults;
import org.openl.rules.ui.tests.results.Test;
import org.openl.rules.webstudio.web.test.TestResultsHelper;
import org.openl.rules.webstudio.web.util.WebStudioUtils;
import org.openl.util.StringTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunAllTestsBean {
    private RanTestsResults testsResult;
    private UIRepeat testUnits;
    private UIRepeat testDataColumnHeaders;

    public RunAllTestsBean() {
        String tableUri = FacesUtils.getRequestParameter((String)"uri");
        String testName = FacesUtils.getRequestParameter((String)"testName");
        if (testName != null) {
            testName = StringTool.decodeURL((String)testName);
        }
        String unitId = FacesUtils.getRequestParameter((String)"testID");
        TestResultsHelper.initExplanator();
        this.testAll(tableUri, testName, unitId);
    }

    private void testAll(String tableUri, String testName, String unitId) {
        ProjectModel model = WebStudioUtils.getProjectModel();
        this.testsResult = StringUtils.isNotBlank((String)unitId) ? model.testUnit(tableUri, testName, unitId) : model.testAll(tableUri);
    }

    public Test[] getRanTests() {
        return this.testsResult.getTests();
    }

    public int getNumberOfTests() {
        return this.testsResult.getTests().length;
    }

    public int getNumberOfFailedTests() {
        return this.testsResult.numberOfFailedTests();
    }

    public int getNumberOfUnits() {
        return this.testsResult.totalNumberOfTestUnits();
    }

    public int getNumberOfFailedUnits() {
        return this.testsResult.totalNumberOfFailures();
    }

    public UIRepeat getTestItems() {
        return this.testUnits;
    }

    public void setTestItems(UIRepeat testItems) {
        this.testUnits = testItems;
    }

    public UIRepeat getTestDataColumnHeaders() {
        return this.testDataColumnHeaders;
    }

    public void setTestDataColumnHeaders(UIRepeat testDataColumnHeaders) {
        this.testDataColumnHeaders = testDataColumnHeaders;
    }

    public List<OpenLMessage> getErrors() {
        Object result = this.getActualResult();
        return TestResultsHelper.getErrors(result);
    }

    private Object getActualResult() {
        TestUnit testUnit = (TestUnit)this.testUnits.getRowData();
        return testUnit.getActualResult();
    }

    public Object getExpected() {
        TestUnit testUnit = (TestUnit)this.testUnits.getRowData();
        return testUnit.getExpectedResult();
    }

    public DoubleValue getDoubleValueExpected() {
        Object expected = this.getExpected();
        return TestResultsHelper.getDoubleValueResult(expected);
    }

    public Object getResult() {
        Object result = this.getActualResult();
        if (result instanceof Throwable) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)((Throwable)result));
            return rootCause.getMessage();
        }
        if (result == null) {
            return TestResultsHelper.format(result);
        }
        return result;
    }

    public DoubleValue getDoubleValueResult() {
        Object result = this.getResult();
        return TestResultsHelper.getDoubleValueResult(result);
    }

    public int getResultExplanatorId() {
        return TestResultsHelper.getExplanatorId(this.getDoubleValueResult());
    }

    public int getExpectedExplanatorId() {
        return TestResultsHelper.getExplanatorId(this.getDoubleValueExpected());
    }

    public int getCompareResult() {
        TestUnit testUnit = (TestUnit)this.testUnits.getRowData();
        return testUnit.compareResult();
    }

    public Object getTestValue() {
        TestUnit testUnit = (TestUnit)this.testUnits.getRowData();
        String header = (String)this.testDataColumnHeaders.getRowData();
        return testUnit.getFieldValue(header);
    }

    public String getFormattedTestValue() {
        Object testValue = this.getTestValue();
        return TestResultsHelper.format(testValue);
    }

    public String getUnitDescription() {
        TestUnit testUnit = (TestUnit)this.testUnits.getRowData();
        return (String)testUnit.getDescription();
    }
}

