/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.test;

import java.util.List;
import org.ajax4jsf.component.UIRepeat;
import org.apache.commons.lang.StringUtils;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.message.OpenLMessage;
import org.openl.meta.DoubleValue;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.ui.ObjectViewer;
import org.openl.rules.ui.WebStudio;
import org.openl.rules.webstudio.web.test.TestResultsHelper;
import org.openl.rules.webstudio.web.util.WebStudioUtils;
import org.openl.util.StringTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunTestMethodBean {
    private String tableName;
    private String testName;
    private String testId;
    private String testDescription;
    private String tableUri;
    private Object[] results;
    private UIRepeat resultItems;

    public RunTestMethodBean() {
        WebStudio studio = WebStudioUtils.getWebStudio();
        this.tableUri = FacesUtils.getRequestParameter((String)"uri");
        if (StringUtils.isNotBlank((String)this.tableUri)) {
            studio.setTableUri(this.tableUri);
        } else {
            this.tableUri = studio.getTableUri();
        }
        TestResultsHelper.initExplanator();
        this.tableName = studio.getModel().getTable(this.tableUri).getName();
        this.testName = FacesUtils.getRequestParameter((String)"testName");
        if (this.testName != null) {
            this.testName = StringTool.decodeURL((String)this.testName);
        }
        this.testId = FacesUtils.getRequestParameter((String)"testID");
        this.testDescription = FacesUtils.getRequestParameter((String)"testDescr");
        this.runTestMethod(this.tableUri, this.testId, this.testName);
    }

    private void runTestMethod(String tableUri, String testId, String testName) {
        WebStudio studio = WebStudioUtils.getWebStudio();
        Object result = studio.getModel().runElement(tableUri, testName, testId);
        this.setResults(result);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTestName() {
        return this.testName;
    }

    public String getTestId() {
        return this.testId;
    }

    public String getTestDescription() {
        return this.testDescription;
    }

    public Object[] getResults() {
        return this.results;
    }

    public String getUri() {
        return this.tableUri;
    }

    private void setResults(Object results) {
        this.results = results == null ? new Object[0] : (results.getClass().isArray() ? (Object[])results : new Object[]{results});
    }

    public UIRepeat getResultItems() {
        return this.resultItems;
    }

    public void setResultItems(UIRepeat resultItems) {
        this.resultItems = resultItems;
    }

    public String getStringResult() {
        Object result = this.resultItems.getRowData();
        return TestResultsHelper.format(result);
    }

    public SpreadsheetResult getSpreadsheetResult() {
        Object result = this.resultItems.getRowData();
        return TestResultsHelper.getSpreadsheetResult(result);
    }

    public String getFormattedSpreadsheetResult() {
        SpreadsheetResult spreadsheetResult = this.getSpreadsheetResult();
        if (spreadsheetResult != null) {
            return new ObjectViewer().displayResult(spreadsheetResult);
        }
        return "";
    }

    public DoubleValue getDoubleValueResult() {
        Object result = this.resultItems.getRowData();
        return TestResultsHelper.getDoubleValueResult(result);
    }

    public int getExplanatorId() {
        return TestResultsHelper.getExplanatorId(this.getDoubleValueResult());
    }

    public List<OpenLMessage> getErrors() {
        Object result = this.resultItems.getRowData();
        return TestResultsHelper.getErrors(result);
    }
}

