/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.test;

import java.util.Collections;
import java.util.List;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.meta.DoubleValue;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.table.xls.formatters.FormattersManager;
import org.openl.rules.ui.Explanator;
import org.openl.util.formatters.IFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResultsHelper {
    private TestResultsHelper() {
    }

    public static DoubleValue getDoubleValueResult(Object result) {
        if (result instanceof DoubleValue) {
            return (DoubleValue)result;
        }
        return null;
    }

    public static int getExplanatorId(DoubleValue doubleValue) {
        return Explanator.getCurrent().getUniqueId(doubleValue);
    }

    public static List<OpenLMessage> getErrors(Object result) {
        if (result instanceof Throwable) {
            return OpenLMessagesUtils.newMessages((Throwable)((Throwable)result));
        }
        return Collections.emptyList();
    }

    @Deprecated
    public static String getNullResult() {
        return "null";
    }

    public static SpreadsheetResult getSpreadsheetResult(Object result) {
        if (result instanceof SpreadsheetResult) {
            return (SpreadsheetResult)result;
        }
        return null;
    }

    public static void initExplanator() {
        Explanator explanator = (Explanator)FacesUtils.getSessionParam((String)"explanator");
        if (explanator == null) {
            explanator = new Explanator();
            FacesUtils.getSessionMap().put("explanator", explanator);
        }
        Explanator.setCurrent(explanator);
    }

    public static String format(Object value) {
        IFormatter formatter = FormattersManager.getFormatter((Object)value);
        return formatter.format(value);
    }
}

