/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.trace;

import java.util.Collections;
import java.util.List;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.ui.TraceHelper;
import org.openl.rules.ui.WebStudio;
import org.openl.rules.webstudio.web.util.WebStudioUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowTraceTableBean {
    private TraceHelper traceHelper;
    private int traceElementId;
    private String tracerUri;
    private String tracerName;

    public ShowTraceTableBean() {
        WebStudio studio = WebStudioUtils.getWebStudio();
        this.traceHelper = studio.getTraceHelper();
        String traceElementIdParam = FacesUtils.getRequestParameter((String)"id");
        this.traceElementId = -100;
        if (traceElementIdParam != null) {
            this.traceElementId = Integer.parseInt(traceElementIdParam);
        }
        this.tracerUri = this.traceHelper.getTracerUri(this.traceElementId);
        this.tracerName = this.traceHelper.getTracerName(this.traceElementId);
    }

    public String getTracerUri() {
        return this.tracerUri;
    }

    public String getTracerName() {
        return this.tracerName;
    }

    public String getTraceTable() {
        WebStudio studio = WebStudioUtils.getWebStudio();
        String view = studio.getModel().getTableView(FacesUtils.getRequestParameter((String)"view"));
        return this.traceHelper.showTrace(this.traceElementId, studio.getModel(), view);
    }

    public List<OpenLMessage> getErrors() {
        Throwable error = this.traceHelper.getTracerError(this.traceElementId);
        if (error != null) {
            Throwable cause = error.getCause();
            if (cause != null) {
                return OpenLMessagesUtils.newMessages((Throwable)cause);
            }
            return OpenLMessagesUtils.newMessages((Throwable)error);
        }
        return Collections.emptyList();
    }
}

