/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.web.trace;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.activation.MimetypesFileTypeMap;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.rules.ui.ProjectModel;
import org.openl.rules.webstudio.web.util.WebStudioUtils;
import org.openl.vm.trace.DefaultTracePrinter;
import org.openl.vm.trace.TraceFormatter;
import org.openl.vm.trace.TraceFormatterFactory;
import org.openl.vm.trace.TracePrinter;
import org.openl.vm.trace.Tracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceIntoFileBean {
    private final Log LOG = LogFactory.getLog(TraceIntoFileBean.class);
    public static final String EXTENSION_SEPARATOR = ".";
    private String tableUri;
    private String fileBaseName = "trace";
    private String fileFormat;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String traceIntoFile() {
        Tracer tracer = this.trace(this.tableUri);
        TracePrinter tracePrinter = this.getTracePrinter(this.fileFormat);
        HttpServletResponse response = (HttpServletResponse)FacesUtils.getResponse();
        this.initResponse(response, this.getFileName());
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            tracePrinter.print(tracer, (Writer)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            this.LOG.error((Object)"Error when printing trace", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        FacesUtils.getFacesContext().responseComplete();
        return null;
    }

    private Tracer trace(String tableUri) {
        ProjectModel model = WebStudioUtils.getProjectModel();
        return model.traceElement(tableUri, null, null);
    }

    private TracePrinter getTracePrinter(String fileFormat) {
        DefaultTracePrinter tracePrinter = new DefaultTracePrinter();
        TraceFormatter traceFormatter = new TraceFormatterFactory().getTraceFormatter(fileFormat);
        tracePrinter.setFormatter(traceFormatter);
        return tracePrinter;
    }

    private void initResponse(HttpServletResponse response, String outputFileName) {
        response.setHeader("Content-disposition", "attachment; filename=" + outputFileName);
        String contentType = new MimetypesFileTypeMap().getContentType(outputFileName);
        response.setContentType(contentType);
    }

    public String getTableUri() {
        return this.tableUri;
    }

    public void setTableUri(String tableUri) {
        this.tableUri = tableUri;
    }

    public String getFileBaseName() {
        return this.fileBaseName;
    }

    public void setFileBaseName(String fileBaseName) {
        this.fileBaseName = fileBaseName;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public String getFileName() {
        StringBuilder result = new StringBuilder();
        result.append(this.fileBaseName);
        if (StringUtils.isNotBlank((String)this.fileFormat)) {
            result.append(EXTENSION_SEPARATOR).append(this.fileFormat);
        }
        return result.toString();
    }

    public List<SelectItem> getFileFormats() {
        ArrayList<SelectItem> fileTypes = new ArrayList<SelectItem>();
        fileTypes.add(new SelectItem((Object)"txt", "Text"));
        return fileTypes;
    }
}

