/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.ICastFactory;
import org.openl.binding.IMethodFactory;
import org.openl.binding.MethodUtil;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.MethodBoundNode;
import org.openl.binding.impl.MethodSearch;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;

public class MethodNodeBinder
extends ANodeBinder {
    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        IBoundNode[] children;
        IOpenClass[] types;
        int childrenCount = node.getNumberOfChildren();
        if (childrenCount < 1) {
            BindHelper.processError((String)"Method node should have at least one subnode", (ISyntaxNode)node, (IBindingContext)bindingContext, (boolean)false);
            return new ErrorBoundNode(node);
        }
        ISyntaxNode lastNode = node.getChild(childrenCount - 1);
        String methodName = ((IdentifierNode)lastNode).getIdentifier();
        IMethodCaller methodCaller = bindingContext.findMethodCaller("org.openl.this", methodName, types = MethodNodeBinder.getTypes((IBoundNode[])(children = MethodNodeBinder.bindChildren((ISyntaxNode)node, (IBindingContext)bindingContext, (int)0, (int)(childrenCount - 1)))));
        if (methodCaller == null) {
            String message = String.format("Method '%s' not found", MethodUtil.printMethod((String)methodName, (IOpenClass[])types));
            BindHelper.processError((String)message, (ISyntaxNode)node, (IBindingContext)bindingContext, (boolean)false);
            return new ErrorBoundNode(node);
        }
        return new MethodBoundNode(node, children, methodCaller);
    }

    public IBoundNode bindTarget(ISyntaxNode node, IBindingContext bindingContext, IBoundNode target) throws Exception {
        IBoundNode[] children;
        IOpenClass[] types;
        int childrenCount = node.getNumberOfChildren();
        if (childrenCount < 1) {
            BindHelper.processError((String)"New node should have at least one subnode", (ISyntaxNode)node, (IBindingContext)bindingContext);
            return new ErrorBoundNode(node);
        }
        ISyntaxNode lastNode = node.getChild(childrenCount - 1);
        String methodName = ((IdentifierNode)lastNode).getIdentifier();
        IMethodCaller methodCaller = MethodSearch.getMethodCaller((String)methodName, (IOpenClass[])(types = MethodNodeBinder.getTypes((IBoundNode[])(children = MethodNodeBinder.bindChildren((ISyntaxNode)node, (IBindingContext)bindingContext, (int)0, (int)(childrenCount - 1))))), (ICastFactory)bindingContext, (IMethodFactory)target.getType());
        if (methodCaller == null) {
            StringBuffer buf = new StringBuffer("Method ");
            MethodUtil.printMethod((String)methodName, (IOpenClass[])types, (StringBuffer)buf);
            buf.append(" not found in '" + target.getType().getName() + "'");
            BindHelper.processError((String)buf.toString(), (ISyntaxNode)node, (IBindingContext)bindingContext, (boolean)false);
            return new ErrorBoundNode(node);
        }
        if (target.isStaticTarget() != methodCaller.getMethod().isStatic()) {
            if (methodCaller.getMethod().isStatic()) {
                BindHelper.processWarn((String)"Access of a static method from non-static object", (ISyntaxNode)node, (IBindingContext)bindingContext);
            } else {
                BindHelper.processError((String)"Access of a non-static method from a static object", (ISyntaxNode)node, (IBindingContext)bindingContext);
                return new ErrorBoundNode(node);
            }
        }
        MethodBoundNode result = new MethodBoundNode(node, children, methodCaller, target);
        result.setTargetNode(target);
        return result;
    }
}

