/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.PrefixNode;
import org.openl.binding.impl.UnaryOperatorNodeBinder;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;

public class PrefixOperatorNodeBinder
extends ANodeBinder {
    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        if (node.getNumberOfChildren() != 1) {
            BindHelper.processError((String)"Prefix node must have 1 subnode", (ISyntaxNode)node, (IBindingContext)bindingContext);
            return new ErrorBoundNode(node);
        }
        int index = node.getType().lastIndexOf(46);
        String methodName = node.getType().substring(index + 1);
        IBoundNode[] children = PrefixOperatorNodeBinder.bindChildren((ISyntaxNode)node, (IBindingContext)bindingContext);
        if (!children[0].isLvalue()) {
            BindHelper.processError((String)"The node is not an Lvalue", (ISyntaxNode)children[0].getSyntaxNode(), (IBindingContext)bindingContext, (boolean)false);
            return new ErrorBoundNode(node);
        }
        IOpenClass[] types = PrefixOperatorNodeBinder.getTypes((IBoundNode[])children);
        IMethodCaller methodCaller = UnaryOperatorNodeBinder.findUnaryOperatorMethodCaller(methodName, types, bindingContext);
        if (methodCaller == null) {
            String message = UnaryOperatorNodeBinder.errorMsg(methodName, types[0]);
            BindHelper.processError((String)message, (ISyntaxNode)node, (IBindingContext)bindingContext);
            return new ErrorBoundNode(node);
        }
        if (!methodCaller.getMethod().getType().equals(types[0])) {
            BindHelper.processError((String)"Prefix operator must return the same type as an argument", (ISyntaxNode)node, (IBindingContext)bindingContext);
            return new ErrorBoundNode(node);
        }
        return new PrefixNode(node, children, methodCaller);
    }
}

