/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.LiteralBoundNode;
import org.openl.exception.OpenLRuntimeException;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.RangeWithBounds;

public class RangeNodeBinder
extends ANodeBinder {
    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        IBoundNode[] children = RangeNodeBinder.bindChildren((ISyntaxNode)node, (IBindingContext)bindingContext);
        if (children[0] instanceof ErrorBoundNode) {
            return new ErrorBoundNode(node);
        }
        RangeWithBounds range = null;
        String type = node.getType();
        if (type.contains("brackets")) {
            range = this.bindBrackets(children, bindingContext);
        } else if (type.contains("binary")) {
            range = this.bindBinary(children, type, bindingContext);
        } else if (type.contains("number")) {
            range = this.bindNumber(children, bindingContext);
        } else if (type.contains("unary.prefix")) {
            range = this.bindPrefix(children, type, bindingContext);
        } else if (type.contains("unary.suffix")) {
            range = this.bindSuffix(children, type, bindingContext);
        }
        if (range == null) {
            String message = String.format("Unsupported range type: %s", type);
            BindHelper.processError((String)message, (ISyntaxNode)node, (IBindingContext)bindingContext, (boolean)false);
            return new ErrorBoundNode(node);
        }
        return new LiteralBoundNode(node, (Object)range, (IOpenClass)JavaOpenClass.getOpenClass(RangeWithBounds.class));
    }

    private RangeWithBounds bindBrackets(IBoundNode[] children, IBindingContext bindingContext) {
        Number min = (Number)((LiteralBoundNode)children[1]).getValue();
        RangeWithBounds.BoundType leftBoundType = ((LiteralBoundNode)children[0]).getValue().equals(Character.valueOf('(')) ? RangeWithBounds.BoundType.EXCLUDING : RangeWithBounds.BoundType.INCLUDING;
        Number max = (Number)((LiteralBoundNode)children[2]).getValue();
        RangeWithBounds.BoundType rightBoundType = ((LiteralBoundNode)children[3]).getValue().equals(Character.valueOf(')')) ? RangeWithBounds.BoundType.EXCLUDING : RangeWithBounds.BoundType.INCLUDING;
        return new RangeWithBounds(min, max, leftBoundType, rightBoundType);
    }

    private RangeWithBounds bindBinary(IBoundNode[] children, String type, IBindingContext bindingContext) {
        Number val = (Number)((LiteralBoundNode)children[0]).getValue();
        Number val2 = (Number)((LiteralBoundNode)children[1]).getValue();
        if (val.doubleValue() > val2.doubleValue()) {
            throw new OpenLRuntimeException(String.format("%s must be more or equal than %s", val2.toString(), val.toString()));
        }
        if (type.endsWith("minus") || type.endsWith("ddot")) {
            return new RangeWithBounds(val, val2);
        }
        if (type.endsWith("tdot")) {
            return new RangeWithBounds(val, val2, RangeWithBounds.BoundType.EXCLUDING, RangeWithBounds.BoundType.EXCLUDING);
        }
        return null;
    }

    private RangeWithBounds bindNumber(IBoundNode[] children, IBindingContext bindingContext) {
        Number val = (Number)((LiteralBoundNode)children[0]).getValue();
        return new RangeWithBounds(val, val);
    }

    private RangeWithBounds bindPrefix(IBoundNode[] children, String type, IBindingContext bindingContext) {
        Number val = (Number)((LiteralBoundNode)children[0]).getValue();
        if (type.endsWith("lt")) {
            return new RangeWithBounds(this.getMin(val), val, RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.EXCLUDING);
        }
        if (type.endsWith("le")) {
            return new RangeWithBounds(this.getMin(val), val, RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
        }
        if (type.endsWith("gt")) {
            return new RangeWithBounds(val, this.getMax(val), RangeWithBounds.BoundType.EXCLUDING, RangeWithBounds.BoundType.INCLUDING);
        }
        if (type.endsWith("ge")) {
            return new RangeWithBounds(val, this.getMax(val), RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
        }
        return null;
    }

    private RangeWithBounds bindSuffix(IBoundNode[] children, String type, IBindingContext bindingContext) {
        Number val = (Number)((LiteralBoundNode)children[0]).getValue();
        if (type.endsWith("lt")) {
            return new RangeWithBounds(val, this.getMax(val), RangeWithBounds.BoundType.EXCLUDING, RangeWithBounds.BoundType.INCLUDING);
        }
        if (type.endsWith("le") || type.endsWith("plus") || type.endsWith("and.more")) {
            return new RangeWithBounds(val, this.getMax(val), RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
        }
        if (type.endsWith("or.less")) {
            return new RangeWithBounds(this.getMin(val), val, RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
        }
        return null;
    }

    private Number getMax(Number number) {
        if (number.getClass() == Double.class) {
            return Double.POSITIVE_INFINITY;
        }
        if (number.getClass() == Long.class) {
            return Long.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private Number getMin(Number number) {
        if (number.getClass() == Double.class) {
            return Double.NEGATIVE_INFINITY;
        }
        if (number.getClass() == Long.class) {
            return Long.MIN_VALUE;
        }
        return Integer.MIN_VALUE;
    }
}

