/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.ccc;

import org.openl.ie.ccc.CccCore;
import org.openl.ie.ccc.CccGoal;
import org.openl.ie.ccc.CccVariable;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.GoalAnd;
import org.openl.ie.constrainer.GoalImpl;
import org.openl.ie.constrainer.GoalMinimize;
import org.openl.ie.constrainer.IntExp;

public class CccInteger
extends CccVariable {
    private int _min;
    private int _max;
    private IntExp _constrainer_integer;
    private String _value;
    private CccGoal _goal_minimize;
    private CccGoal _goal_maximize;

    public CccInteger(CccCore core, int min, int max, String name) {
        super(core, 1, name);
        this._goal_minimize = null;
        this._goal_maximize = null;
        try {
            this._constrainer_integer = core.constrainer().addIntVar(min, max, name);
        }
        catch (Exception e) {
            core.traceln("Invalid min/max: " + e);
        }
        this.fetchConstrainerState();
    }

    public CccInteger(CccCore core, IntExp i) {
        this(core, i, i.name());
    }

    public CccInteger(CccCore core, IntExp i, String newname) {
        super(core, 1, newname);
        this._constrainer_integer = i;
        this.fetchConstrainerState();
    }

    public IntExp constrainerInteger() {
        return this._constrainer_integer;
    }

    public void constrainerInteger(IntExp var) {
        this._constrainer_integer = var;
    }

    public String debugInfo() {
        return "observers=" + this._constrainer_integer.observers().size() + "deps=" + this._constrainer_integer.allDependents().size();
    }

    public void fetchConstrainerState() {
        this.value(this._constrainer_integer.domainToString());
        this.bound(this._constrainer_integer.bound());
        this.min(this._constrainer_integer.min());
        this.max(this._constrainer_integer.max());
        if (!this.bound()) {
            this.status(0);
        } else {
            this.status(1);
        }
    }

    public CccGoal getMaximizeGoal() {
        if (this._goal_maximize == null) {
            this._goal_maximize = new CccGoal(this.core(), "MAXIMIZE");
            this._goal_maximize.executable(new GoalMinimize(this.core().getGoalSolution().executable(), this._constrainer_integer.neg()));
        }
        return this._goal_maximize;
    }

    public CccGoal getMinimizeGoal() {
        if (this._goal_minimize == null) {
            this._goal_minimize = new CccGoal(this.core(), "MINIMIZE");
            this._goal_minimize.executable(new GoalAnd(new GoalImpl(this.core().constrainer()){

                public Goal execute() {
                    CccInteger.this.core().traceln("Minimize STARTED!");
                    CccInteger.this.core().traceVars();
                    return null;
                }
            }, new GoalMinimize(this.core().getGoalSolution().executable(), this._constrainer_integer), new GoalImpl(this.core().constrainer()){

                public Goal execute() {
                    CccInteger.this.core().traceln("Minimize FINISHED!");
                    CccInteger.this.core().traceVars();
                    return null;
                }
            }));
        }
        return this._goal_minimize;
    }

    public int max() {
        return this._max;
    }

    public void max(int m) {
        this._max = m;
    }

    public int min() {
        return this._min;
    }

    public void min(int m) {
        this._min = m;
    }

    public String toString() {
        return this.name() + this.value();
    }

    public String value() {
        return this._value;
    }

    public void value(String v) {
        this._value = v;
    }
}

