/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer;

import org.openl.ie.constrainer.ChoicePointLabel;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.GoalAnd;
import org.openl.ie.constrainer.GoalImpl;
import org.openl.ie.constrainer.GoalOr;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.impl.ConstraintExpLessValue;
import org.openl.util.Log;

public class GoalFastMinimize
extends GoalImpl {
    private IntExp _cost;
    private int _best_cost;
    private Goal _goal_find_solution;
    private ConstraintExpLessValue _constraint_limit_cost;
    private int _number_of_solutions;
    private boolean _trace;
    private Object _client_tracer;
    private boolean _goal_saves_solution;
    private ChoicePointLabel _rootLabel;
    private int _initial_cost_min;
    private int _initial_cost_max;
    private int _cost_search_max;

    public GoalFastMinimize(Goal goal, IntExp cost) {
        this(goal, cost, false, false);
    }

    public GoalFastMinimize(Goal goal, IntExp cost, boolean goal_saves_solution) {
        this(goal, cost, false, goal_saves_solution);
    }

    public GoalFastMinimize(Goal goal, IntExp cost, boolean trace, boolean goal_saves_solution) {
        super(cost.constrainer(), "");
        this._goal_find_solution = goal;
        this._cost = cost;
        this._constraint_limit_cost = new ConstraintExpLessValue(this._cost, this._cost.max() + 1);
        this._number_of_solutions = 0;
        this._trace = trace;
        this._client_tracer = null;
        this._goal_saves_solution = goal_saves_solution;
        this._rootLabel = this.constrainer().createChoicePointLabel();
        this._initial_cost_min = this._cost.min();
        this._cost_search_max = this._initial_cost_max = this._cost.max();
    }

    public GoalFastMinimize(Goal goal, IntExp cost, Object tracer) {
        this(goal, cost, false);
        this._client_tracer = tracer;
    }

    public GoalFastMinimize(Goal goal, IntExp cost, Object tracer, boolean goal_saves_solution) {
        this(goal, cost, false, goal_saves_solution);
        this._client_tracer = tracer;
    }

    public Goal execute() throws Failure {
        if (this._number_of_solutions > 0) {
            return new AnalyzeAndSet(this.constrainer());
        }
        if (!this.increaseCostSearchMax()) {
            this.constrainer().fail("GoalFastMinimize");
        }
        return new GoalOr(new FindAndImprove(this.constrainer()), this, this._rootLabel);
    }

    boolean increaseCostSearchMax() {
        if (this._cost_search_max > this._initial_cost_max) {
            return false;
        }
        if (this._cost_search_max < this._initial_cost_min + 1) {
            this._cost_search_max = this._initial_cost_min + 1;
        } else {
            this._cost_search_max = this._initial_cost_min + (this._cost_search_max - this._initial_cost_min) * 2;
            if (this._cost_search_max > this._initial_cost_max + 1) {
                this._cost_search_max = this._initial_cost_max + 1;
            }
        }
        return true;
    }

    public String toString() {
        return "Use " + this._goal_find_solution.name() + " to minimize(" + this._cost.name() + ")";
    }

    class GoalBacktrack
    extends GoalImpl {
        public GoalBacktrack(Constrainer c) {
            super(c, "GoalBacktrack");
        }

        public Goal execute() throws Failure {
            this.fixFoundSolution();
            ChoicePointLabel lbl = this.constrainer().currentChoicePointLabel();
            while ((lbl == null || !lbl.equals(GoalFastMinimize.this._rootLabel)) && this.violated()) {
                if (!this.constrainer().backtrack()) {
                    throw new RuntimeException("Internal error in" + this);
                }
                lbl = this.constrainer().currentChoicePointLabel();
                if (!GoalFastMinimize.this._trace) continue;
                Log.info((Object)(" Backtrack: cost" + GoalFastMinimize.this._cost.domainToString() + " best_cost=" + GoalFastMinimize.this._best_cost));
            }
            if (this.violated()) {
                this.constrainer().fail("GoalBacktrack");
            }
            GoalFastMinimize.this._constraint_limit_cost.resetValue(GoalFastMinimize.this._best_cost);
            return null;
        }

        void fixFoundSolution() throws Failure {
            GoalFastMinimize.this._best_cost = GoalFastMinimize.this._cost.value();
            GoalFastMinimize.this._number_of_solutions++;
            if (GoalFastMinimize.this._trace) {
                Log.info((Object)("Solution " + GoalFastMinimize.this._number_of_solutions + ": cost=" + GoalFastMinimize.this._cost.value()));
            }
            if (GoalFastMinimize.this._client_tracer != null) {
                Log.info((Object)GoalFastMinimize.this._client_tracer.toString());
            }
        }

        boolean violated() {
            return GoalFastMinimize.this._cost.min() >= GoalFastMinimize.this._best_cost;
        }
    }

    class FindAndImprove
    extends GoalImpl {
        FindAndImprove(Constrainer C) {
            super(C, "FindAndImprove");
        }

        public Goal execute() throws Failure {
            GoalFastMinimize.this._constraint_limit_cost.resetValue(GoalFastMinimize.this._cost_search_max);
            GoalFastMinimize.this._constraint_limit_cost.post();
            return new GoalAnd(GoalFastMinimize.this._goal_find_solution, new GoalBacktrack(this.constrainer()));
        }
    }

    class AnalyzeAndSet
    extends GoalImpl {
        AnalyzeAndSet(Constrainer C) {
            super(C, "AnalyzeAndSet");
        }

        public Goal execute() throws Failure {
            if (GoalFastMinimize.this._number_of_solutions <= 0) {
                this.constrainer().fail();
            }
            if (GoalFastMinimize.this._goal_saves_solution) {
                return null;
            }
            GoalFastMinimize.this._cost.equals(GoalFastMinimize.this._best_cost).post();
            return GoalFastMinimize.this._goal_find_solution;
        }
    }
}

