/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer;

import org.openl.ie.constrainer.ChoicePointLabel;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.GoalAnd;
import org.openl.ie.constrainer.GoalImpl;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.TimeLimitException;
import org.openl.util.Log;

public class GoalMinimize
extends GoalImpl {
    private IntExp _cost;
    private Goal _find_solution;
    private int _best_cost_min;
    private int _best_cost_max;
    private int _precision;
    private int _number_of_choice_points;
    private int _number_of_failures;
    private int _number_of_solutions;
    private int _number_of_attempts;
    private boolean _goal_saves_solution;
    private Goal _goal_set_cost_max;

    public GoalMinimize(Goal goal, IntExp cost) {
        this(goal, cost, 0, false);
    }

    public GoalMinimize(Goal goal, IntExp cost, boolean goal_saves_solution) {
        this(goal, cost, 0, goal_saves_solution);
    }

    public GoalMinimize(Goal goal, IntExp cost, int precision) {
        this(goal, cost, precision, false);
    }

    public GoalMinimize(Goal goal, IntExp cost, int precision, boolean goal_saves_solution) {
        super(cost.constrainer(), "");
        this._find_solution = goal;
        this._cost = cost;
        this._best_cost_max = this._cost.max();
        this._best_cost_min = this._cost.min();
        this._precision = precision;
        this._number_of_choice_points = 0;
        this._number_of_failures = 0;
        this._number_of_solutions = 0;
        this._number_of_attempts = 0;
        this._goal_set_cost_max = new SetCostMax(this._cost);
        this._goal_saves_solution = goal_saves_solution;
    }

    private int bestCostMax() {
        return this._best_cost_max;
    }

    private void bestCostMax(int max) {
        this._best_cost_max = max;
    }

    private int bestCostMin() {
        return this._best_cost_min;
    }

    private void bestCostMin(int min) {
        this._best_cost_min = min;
    }

    public IntExp cost() {
        return this._cost;
    }

    public Goal execute() throws Failure {
        double new_cost = (double)(this.bestCostMin() + this.bestCostMax()) / 2.0;
        int best_cost = (int)Math.floor(new_cost);
        if (this.bestCostMax() - this.bestCostMin() <= this._precision) {
            if (this._number_of_solutions > 0 || this._number_of_attempts == 0) {
                this.constrainer().numberOfChoicePoints(this._number_of_choice_points);
                this.constrainer().numberOfFailures(this._number_of_failures);
                if (this._number_of_solutions > 0) {
                    Log.info((Object)("Minimize Succeeded with cost[" + this.bestCostMin() + ";" + this.bestCostMax() + "]" + ". Total Choice Points=" + this._number_of_choice_points + " Failures=" + this._number_of_failures + " Number of solutions=" + this._number_of_solutions));
                }
                if (this._goal_saves_solution) {
                    return null;
                }
                return new GoalAnd(this.setCost(), this.findSolution());
            }
            this.constrainer().fail("no solutions");
            return null;
        }
        boolean restore = true;
        ++this._number_of_attempts;
        try {
            if (!this.constrainer().execute((Goal)new GoalAnd(this.cost().moreOrEqual(this.bestCostMin()), this.cost().lessOrEqual(best_cost), this.findSolution(), this._goal_set_cost_max), restore)) {
                this.bestCostMin(best_cost + 1);
            } else {
                ++this._number_of_solutions;
            }
        }
        catch (TimeLimitException ex) {
            this.constrainer().fail();
        }
        this._number_of_choice_points += this.constrainer().numberOfChoicePoints();
        this._number_of_failures += this.constrainer().numberOfFailures();
        return this;
    }

    public Goal findSolution() {
        return this._find_solution;
    }

    Goal setCost() {
        return new GoalAnd(this._cost.moreOrEqual(this.bestCostMin()), this._cost.lessOrEqual(this.bestCostMax()));
    }

    public boolean toContinue(ChoicePointLabel label, boolean restoration) {
        double new_cost = (double)(this.bestCostMin() + this.bestCostMax()) / 2.0;
        int best_cost = (int)Math.floor(new_cost);
        if (!this.constrainer().toContinue(label, true)) {
            this.bestCostMin(best_cost + 1);
        } else {
            ++this._number_of_solutions;
        }
        this._number_of_choice_points += this.constrainer().numberOfChoicePoints();
        this._number_of_failures += this.constrainer().numberOfFailures();
        return this.constrainer().execute(this);
    }

    public String toString() {
        return "Use " + this._find_solution.name() + " to minimize(" + this._cost.name() + ")";
    }

    class SetCostMax
    extends GoalImpl {
        private IntExp _cost;

        SetCostMax(IntExp cost) {
            super(cost.constrainer());
            this._cost = cost;
        }

        public Goal execute() throws Failure {
            GoalMinimize.this.bestCostMax(this._cost.value());
            return null;
        }
    }
}

