/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.ConstrainerObjectImpl;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntArray;
import org.openl.ie.constrainer.IntArrayCards;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntExpConst;
import org.openl.ie.constrainer.impl.IntExpAddArray1;
import org.openl.ie.constrainer.impl.IntExpArrayElement1;
import org.openl.ie.constrainer.impl.IntExpCardIntExp;
import org.openl.ie.tools.FastVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntExpArray
extends ConstrainerObjectImpl {
    private IntExp[] _data;
    private IntArrayCards _cards = null;

    public IntExpArray(Constrainer c, FastVector v) {
        this(c, v.size());
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = (IntExp)v.elementAt(i);
        }
    }

    public IntExpArray(Constrainer c, int size) {
        super(c);
        this._data = new IntExp[size];
    }

    public IntExpArray(Constrainer c, int size, int min, int max, String array_name) {
        this(c, size);
        this.name(array_name);
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = c.addIntVar(min, max, array_name + "(" + i + ")");
        }
    }

    public IntExpArray(Constrainer c, int size, int min, int max, String array_name, int int_domain) {
        this(c, size);
        this.name(array_name);
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = c.addIntVar(min, max, array_name + "(" + i + ")", int_domain);
        }
    }

    public IntExpArray(Constrainer c, IntExp e0) {
        this(c, 1);
        this._data[0] = e0;
    }

    public IntExpArray(Constrainer c, IntExp e0, IntExp e1) {
        this(c, 2);
        this._data[0] = e0;
        this._data[1] = e1;
    }

    public IntExpArray(Constrainer c, IntExp e0, IntExp e1, IntExp e2) {
        this(c, 3);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
    }

    public IntExpArray(Constrainer c, IntExp e0, IntExp e1, IntExp e2, IntExp e3) {
        this(c, 4);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
    }

    public IntExpArray(Constrainer c, IntExp e0, IntExp e1, IntExp e2, IntExp e3, IntExp e4) {
        this(c, 5);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
        this._data[4] = e4;
    }

    public IntExpArray(Constrainer c, IntExp e0, IntExp e1, IntExp e2, IntExp e3, IntExp e4, IntExp e5) {
        this(c, 6);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
        this._data[4] = e4;
        this._data[5] = e5;
    }

    public IntExpArray(Constrainer c, IntExp e0, IntExp e1, IntExp e2, IntExp e3, IntExp e4, IntExp e5, IntExp e6) {
        this(c, 7);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
        this._data[4] = e4;
        this._data[5] = e5;
        this._data[6] = e6;
    }

    public IntExpArray(Constrainer c, IntExp e0, IntExp e1, IntExp e2, IntExp e3, IntExp e4, IntExp e5, IntExp e6, IntExp e7) {
        this(c, 8);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
        this._data[4] = e4;
        this._data[5] = e5;
        this._data[6] = e6;
        this._data[7] = e7;
    }

    public IntExpArray(Constrainer c, IntExp e0, IntExp e1, IntExp e2, IntExp e3, IntExp e4, IntExp e5, IntExp e6, IntExp e7, IntExp e8) {
        this(c, 9);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
        this._data[4] = e4;
        this._data[5] = e5;
        this._data[6] = e6;
        this._data[7] = e7;
        this._data[8] = e8;
    }

    public IntExpArray(Constrainer c, IntExp[] vars) {
        super(c);
        this._data = new IntExp[vars.length];
        System.arraycopy(vars, 0, this._data, 0, vars.length);
    }

    public IntExpArray(Constrainer c, List<IntExp> v) {
        this(c, v.size());
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = v.get(i);
        }
    }

    public IntExp cardinality(IntExp exp) throws Failure {
        return new IntExpCardIntExp(this, exp);
    }

    public IntArrayCards cards() throws Failure {
        if (this._cards == null) {
            this._cards = new IntArrayCards(this._constrainer, this);
        }
        return this._cards;
    }

    public IntExp[] data() {
        return this._data;
    }

    public long domainsProductCard() {
        int size = this.size();
        if (size == 0) {
            return 0L;
        }
        long total = this._data[0].size();
        for (int i = 1; i < size; ++i) {
            total *= (long)this._data[i].size();
        }
        return total;
    }

    public IntExp elementAt(int idx) {
        return this._data[idx];
    }

    public IntExp elementAt(IntExp exp) throws Failure {
        return new IntExpArrayElement1(this, exp);
    }

    public IntExp get(int idx) {
        return this._data[idx];
    }

    public int max() {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < this._data.length; ++i) {
            int maxi = this._data[i].max();
            if (maxi <= max) continue;
            max = maxi;
        }
        return max;
    }

    public IntExpArray merge(IntExpArray array) {
        int i;
        ArrayList<IntExp> new_data = new ArrayList<IntExp>(this._data.length + array._data.length);
        for (i = 0; i < this._data.length; ++i) {
            new_data.add(this._data[i]);
        }
        for (i = 0; i < array._data.length; ++i) {
            new_data.add(array._data[i]);
        }
        return new IntExpArray(this.constrainer(), new_data);
    }

    public int min() {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < this._data.length; ++i) {
            int mini = this._data[i].min();
            if (mini >= min) continue;
            min = mini;
        }
        return min;
    }

    public IntExp mul(IntArray array) {
        if (this.size() != array.size()) {
            throw new RuntimeException("IntExpArray.mul(IntArray) arrays have different sizes");
        }
        int[] factors = array.data();
        switch (this.size()) {
            case 0: {
                return (IntExp)this._constrainer.expressionFactory().getExpression(IntExpConst.class, new Object[]{this._constrainer, new Integer(0)});
            }
            case 1: {
                return this._data[0].mul(factors[0]);
            }
        }
        IntExpArray products = new IntExpArray(this.constrainer(), this.size());
        for (int i = 0; i < this.size(); ++i) {
            products.set(this._data[i].mul(factors[i]), i);
        }
        return products.sum();
    }

    public IntExp mul(IntExpArray array) {
        if (this.size() != array.size()) {
            throw new RuntimeException("IntExpArray.mul(IntExpArray) arrays have different sizes");
        }
        switch (this.size()) {
            case 0: {
                return (IntExp)this._constrainer.expressionFactory().getExpression(IntExpConst.class, new Object[]{this._constrainer, new Integer(0)});
            }
            case 1: {
                return this._data[0].mul(array._data[0]);
            }
        }
        IntExpArray products = new IntExpArray(this.constrainer(), this.size());
        for (int i = 0; i < this.size(); ++i) {
            products.set(this._data[i].mul(array._data[i]), i);
        }
        return products.sum();
    }

    @Override
    public void name(String name) {
        this.symbolicName(name);
    }

    public void set(IntExp exp, int idx) {
        this._data[idx] = exp;
    }

    public int size() {
        return this._data.length;
    }

    public void sort(Comparator<IntExp> c) {
        Arrays.sort(this._data, c);
    }

    public void sortByDependents() {
        this.sort(new Comparator<IntExp>(){

            @Override
            public int compare(IntExp o1, IntExp o2) {
                return o2.allDependents().size() - o1.allDependents().size();
            }
        });
    }

    public IntExpArray subarray(int min_index, int max_index) {
        if (min_index > max_index) {
            return new IntExpArray(this.constrainer(), 0);
        }
        ArrayList<IntExp> sub_data = new ArrayList<IntExp>(max_index - min_index + 1);
        for (int i = min_index; i <= max_index; ++i) {
            sub_data.add(this._data[i]);
        }
        return new IntExpArray(this.constrainer(), sub_data);
    }

    public IntExpArray subarrayByMask(boolean[] mask) {
        int size = Math.min(this._data.length, mask.length);
        ArrayList<IntExp> sub_data = new ArrayList<IntExp>();
        for (int i = 0; i < size; ++i) {
            if (!mask[i]) continue;
            sub_data.add(this._data[i]);
        }
        return new IntExpArray(this.constrainer(), sub_data);
    }

    public IntExp sum() {
        switch (this.size()) {
            case 0: {
                return (IntExp)this._constrainer.expressionFactory().getExpression(IntExpConst.class, new Object[]{this._constrainer, new Integer(0)});
            }
            case 1: {
                return this._data[0];
            }
            case 2: {
                return this._data[0].add(this._data[1]);
            }
        }
        return (IntExp)this._constrainer.expressionFactory().getExpression(IntExpAddArray1.class, new Object[]{this._constrainer, this});
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i < this._data.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(this._data[i]);
        }
        buf.append("]");
        return buf.toString();
    }
}

