/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer;

import java.util.Map;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.ConstraintConst;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.FloatExpConst;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.impl.ConstraintExpEqualsValue;
import org.openl.ie.constrainer.impl.ConstraintExpLessValue;
import org.openl.ie.constrainer.impl.ConstraintExpMoreValue;
import org.openl.ie.constrainer.impl.IntExpBitAndExp;
import org.openl.ie.constrainer.impl.IntExpImpl;

public class IntExpConst
extends IntExpImpl {
    protected final int _const;

    public IntExpConst(Constrainer constrainer, int c) {
        super(constrainer);
        if (this.constrainer().showInternalNames()) {
            this._name = Integer.toString(c);
        }
        this._const = c;
    }

    public final IntExp add(int value) {
        return this.getIntExp(IntExpConst.class, this._const + value);
    }

    public final IntExp add(IntExp exp) {
        return exp.add(this._const);
    }

    public final FloatExp asFloat() {
        return this.getFloatExp(FloatExpConst.class, this._const);
    }

    public IntExp bitAnd(IntExp exp) {
        return this.getIntExp(IntExpBitAndExp.class, (IntExp)this, exp);
    }

    public final boolean bound() {
        return true;
    }

    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        return (double)this._const * factor;
    }

    public final boolean contains(int value) {
        return value == this._const;
    }

    public final IntExp div(int c) {
        if (c == 0) {
            throw new IllegalArgumentException("Division by zero");
        }
        return this.getIntExp(IntExpConst.class, this._const / c);
    }

    public final Constraint equals(int value) {
        return new ConstraintConst(this.constrainer(), value == this._const);
    }

    public final Constraint equals(IntExp exp) {
        return new ConstraintExpEqualsValue(exp, this._const);
    }

    public final Constraint equals(IntExp exp, int value) {
        return new ConstraintExpEqualsValue(exp, this._const - value);
    }

    public boolean isInteger() {
        return true;
    }

    public boolean isLinear() {
        return true;
    }

    public final Constraint less(int value) {
        return new ConstraintConst(this.constrainer(), this._const < value);
    }

    public final Constraint less(IntExp exp) {
        return new ConstraintExpMoreValue(exp, this._const);
    }

    public final Constraint lessOrEqual(int value) {
        return new ConstraintConst(this.constrainer(), this._const <= value);
    }

    public final Constraint lessOrEqual(IntExp exp) {
        return new ConstraintExpMoreValue(exp, this._const - 1);
    }

    public final int max() {
        return this._const;
    }

    public final int min() {
        return this._const;
    }

    public final Constraint more(int value) {
        return new ConstraintConst(this.constrainer(), this._const > value);
    }

    public final Constraint more(IntExp exp) {
        return new ConstraintExpLessValue(exp, this._const);
    }

    public final Constraint moreOrEqual(int value) {
        return this.more(value - 1);
    }

    public final Constraint moreOrEqual(IntExp exp) {
        return new ConstraintExpLessValue(exp, this._const + 1);
    }

    public final IntExp mul(int c) {
        return this.getIntExp(IntExpConst.class, this._const * c);
    }

    public final IntExp mul(IntExp exp) {
        return exp.mul(this._const);
    }

    public final IntExp neg() {
        return this.getIntExp(IntExpConst.class, -this._const);
    }

    public final void propagate() throws Failure {
    }

    public final void removeValue(int value) throws Failure {
        if (value == this._const) {
            this.constrainer().fail("remove const");
        }
    }

    public final void setMax(int max) throws Failure {
        if (max < this._const) {
            this.constrainer().fail("max<const");
        }
    }

    public final void setMin(int min) throws Failure {
        if (min > this._const) {
            this.constrainer().fail("min>const");
        }
    }

    public final void setValue(int value) throws Failure {
        if (value != this._const) {
            this.constrainer().fail("value!=const");
        }
    }

    public final int size() {
        return 1;
    }

    public final IntExp sub(IntExp exp) {
        return exp.neg().add(this._const);
    }

    public final int value() throws Failure {
        return this._const;
    }
}

