/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.GoalImpl;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntExpArray;
import org.openl.ie.constrainer.impl.ArcConsistency;

public class ArcConsistency_1
implements ArcConsistency {
    private IntExpArray _vars;
    private Bitset[] _domains;
    private ReviseIJ _reviseIJ;
    private int _total_checks;

    static Bitset[] createDomains(IntExpArray vars) {
        Bitset[] domains = new Bitset[vars.size()];
        for (int i = 0; i < vars.size(); ++i) {
            domains[i] = new Bitset(vars.elementAt(i));
        }
        return domains;
    }

    public static long productInitialSize(Bitset[] ary) {
        int size = ary.length;
        if (size == 0) {
            return 0L;
        }
        long total = 1L;
        for (int i = 0; i < size; ++i) {
            total *= (long)ary[i].initialSize();
        }
        return total;
    }

    public static long productSize(Bitset[] ary) {
        int size = ary.length;
        if (size == 0) {
            return 0L;
        }
        long total = 1L;
        for (int i = 0; i < size; ++i) {
            total *= (long)ary[i].size();
        }
        return total;
    }

    public void arcConsistency(IntExpArray vars) throws Failure {
        this.init(vars);
        try {
            this.revise();
        }
        catch (Failure f) {
            this.cleanup();
            throw f;
        }
        this.cleanup();
    }

    void cleanup() {
        this._vars = null;
        this._domains = null;
        this._reviseIJ = null;
    }

    void init(IntExpArray vars) {
        this._vars = vars;
        this._domains = ArcConsistency_1.createDomains(this._vars);
        this._reviseIJ = new ReviseIJ(vars.constrainer());
        this._total_checks = 0;
    }

    void reduceDomains() throws Failure {
        for (int I = 0; I < this._vars.size(); ++I) {
            IntExp exp = this._vars.elementAt(I);
            for (int i = exp.min(); i <= exp.max(); ++i) {
                if (this._domains[I].contains(i)) continue;
                exp.removeValue(i);
            }
        }
    }

    void revise() throws Failure {
        long t2;
        boolean change;
        long t_start = System.currentTimeMillis();
        int size = this._vars.size();
        do {
            change = false;
            for (int I = 0; I < size; ++I) {
                for (int J = 0; J < size; ++J) {
                    if (I == J) continue;
                    change |= this._reviseIJ.revise(I, J);
                }
            }
        } while (change);
        long t = System.currentTimeMillis() - t_start;
        long t1 = ArcConsistency_1.productInitialSize(this._domains);
        if (t1 != (t2 = ArcConsistency_1.productSize(this._domains))) {
            System.out.println("AC_1: t=" + t + "msec checks=" + this._total_checks + " initial_cards=" + t1 + " reduced_cards=" + t2);
        } else {
            System.out.println("AC_1: t=" + t + "msec checks=" + this._total_checks + " initial_cards=" + t1 + " NO reduction");
        }
        this.reduceDomains();
    }

    private class ReviseIJ
    extends GoalImpl {
        private BitsetIterator _itI;
        private BitsetIterator _itJ;
        private int _I;
        private int _i;
        private int _J;
        private int _j;

        public ReviseIJ(Constrainer c) {
            super(c);
            this._itI = new BitsetIterator();
            this._itJ = new BitsetIterator();
        }

        public boolean check_i() {
            this._itJ.reset(ArcConsistency_1.this._domains[this._J]);
            while (this._itJ.hasNext()) {
                this._j = this._itJ.next();
                if (!this.constrainer().execute((Goal)this, true)) continue;
                return true;
            }
            return false;
        }

        public Goal execute() throws Failure {
            ArcConsistency_1.this._total_checks++;
            ArcConsistency_1.this._vars.elementAt(this._I).setValue(this._i);
            ArcConsistency_1.this._vars.elementAt(this._J).setValue(this._j);
            return null;
        }

        public boolean revise(int I, int J) {
            this._I = I;
            this._J = J;
            int removed = 0;
            this._itI.reset(ArcConsistency_1.this._domains[I]);
            while (this._itI.hasNext()) {
                this._i = this._itI.next();
                if (this.check_i()) continue;
                ArcConsistency_1.this._domains[I].removeValue(this._i);
                ++removed;
            }
            return removed > 0;
        }
    }

    public static final class BitsetIterator {
        private Bitset _bits;
        private int _value;

        public BitsetIterator() {
        }

        public BitsetIterator(Bitset bits) {
            this.reset(bits);
        }

        public boolean hasNext() {
            return this._bits.next(this._value) != this._value;
        }

        public int next() {
            if (!this.hasNext()) {
                throw new RuntimeException("BitsetIterator.next()");
            }
            this._value = this._bits.next(this._value);
            return this._value;
        }

        public void reset() {
            this._value = this._bits.min() - 1;
        }

        public void reset(Bitset bits) {
            this._bits = bits;
            this._value = this._bits.min() - 1;
        }
    }

    public static final class Bitset {
        private boolean[] _bits;
        private int _initial_size;
        private int _initial_min;
        private int _initial_max;
        private int _size;
        private int _min;
        private int _max;

        public Bitset(IntExp exp) {
            this._max = this._initial_max = exp.max();
            this._min = this._initial_min = exp.min();
            this._bits = new boolean[this._initial_max - this._initial_min + 1];
            this._initial_size = 0;
            for (int i = 0; i < this._bits.length; ++i) {
                if (exp.contains(this._initial_min + i)) {
                    this._bits[i] = true;
                    ++this._initial_size;
                    continue;
                }
                this._bits[i] = false;
            }
            this._size = this._initial_size;
        }

        public boolean contains(int value) {
            if (value < this._min || value > this._max) {
                return false;
            }
            return this._bits[value - this._initial_min];
        }

        public int initialSize() {
            return this._initial_size;
        }

        public boolean isEmpty() {
            return this._size == 0;
        }

        public int max() {
            return this._max;
        }

        public int min() {
            return this._min;
        }

        public int next(int value) {
            int i = value + 1;
            if (i < this._min || i > this._max) {
                return value;
            }
            while (i <= this._max) {
                if (this._bits[i - this._initial_min]) {
                    return i;
                }
                ++i;
            }
            return value;
        }

        String printIntervals() {
            StringBuffer buf = new StringBuffer();
            int i = this._min;
            while (i <= this._max) {
                int from;
                int to;
                if (i != this._min) {
                    buf.append(" ");
                }
                if ((to = this.upperBound(from = i)) - from == 1) {
                    buf.append(String.valueOf(from));
                } else {
                    buf.append(from + ".." + (to - 1));
                }
                i = this.upperBound(to);
            }
            return buf.toString();
        }

        public boolean removeValue(int value) {
            if (!this.contains(value)) {
                return false;
            }
            if (value == this._min) {
                this._min = value + 1;
            }
            if (value == this._max) {
                this._max = value - 1;
            }
            this._bits[value - this._initial_min] = false;
            --this._size;
            return true;
        }

        public int size() {
            return this._size;
        }

        public String toString() {
            return "[" + this.printIntervals() + "]";
        }

        int upperBound(int i) {
            if (i > this._max) {
                return i;
            }
            boolean sample = this._bits[i - this._initial_min];
            int j = i;
            while (j <= this._max && this._bits[j - this._initial_min] == sample) {
                ++j;
            }
            return j;
        }
    }
}

