/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.ConstraintImpl;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntExpArray;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.UndoBits;
import org.openl.ie.constrainer.impl.UndoableBits;

public final class ConstraintAllDiff
extends ConstraintImpl {
    private IntExpArray _intvars;
    private UndoableBits _bits;

    public ConstraintAllDiff(IntExpArray intvars) {
        super(intvars.constrainer(), "AllDiff");
        this._intvars = intvars;
        int min = intvars.min();
        int max = intvars.max();
        this._bits = new UndoableBits(this.constrainer(), min, max);
        this._bits.object(this);
    }

    UndoableBits bits() {
        return this._bits;
    }

    void bits(UndoableBits b) {
        this._bits = b;
    }

    public Goal execute() throws Failure {
        int size = this._intvars.size();
        for (int i = 0; i < size; ++i) {
            IntExp vari = this._intvars.elementAt(i);
            if (!vari.bound()) continue;
            int value = vari.value();
            boolean bit = this._bits.bit(value);
            if (bit) {
                this.constrainer().fail("Diff");
            }
            this._bits.bit(value, true);
            this.constrainer().addUndo(UndoBits.getUndo(this._bits, value));
        }
        AllDiffObserver value_observer = new AllDiffObserver();
        AllDiffMinMaxObserver minmax_observer = new AllDiffMinMaxObserver();
        for (int i = 0; i < size; ++i) {
            IntExp vari = this._intvars.elementAt(i);
            vari.attachObserver(value_observer);
        }
        return null;
    }

    class AllDiffObserver
    extends Observer {
        AllDiffObserver() {
        }

        public Object master() {
            return ConstraintAllDiff.this;
        }

        public int subscriberMask() {
            return 1;
        }

        public String toString() {
            return "AllDiff";
        }

        public void update(Subject var, EventOfInterest interest) throws Failure {
            IntExp event_var = (IntExp)var;
            int size = ConstraintAllDiff.this._intvars.size();
            int value = event_var.value();
            boolean bit = ConstraintAllDiff.this._bits.bit(value);
            if (bit) {
                var.constrainer().fail("AllDiff");
            }
            ConstraintAllDiff.this._bits.bit(value, true);
            var.constrainer().addUndo(UndoBits.getUndo(ConstraintAllDiff.this._bits, value));
            IntExp[] data = ConstraintAllDiff.this._intvars.data();
            for (int i = 0; i < size; ++i) {
                IntExp vari = data[i];
                if (vari == event_var) continue;
                vari.removeValue(value);
            }
        }
    }

    class AllDiffMinMaxObserver
    extends Observer {
        AllDiffMinMaxObserver() {
        }

        public Object master() {
            return ConstraintAllDiff.this;
        }

        public int subscriberMask() {
            return 6;
        }

        public void update(Subject var, EventOfInterest interest) throws Failure {
            int min = ConstraintAllDiff.this._bits.min();
            int max = ConstraintAllDiff.this._bits.max();
            block0: for (int i = 0; i < ConstraintAllDiff.this._intvars.size(); ++i) {
                IntExp vari = ConstraintAllDiff.this._intvars.elementAt(i);
                if (vari.bound()) continue;
                for (int v = min; v <= max; ++v) {
                    if (!ConstraintAllDiff.this._bits.bit(v) || !vari.contains(v)) continue;
                    vari.removeValue(v);
                    if (vari.bound()) continue block0;
                }
            }
        }
    }
}

