/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.ConstraintImpl;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.IntArray;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntEvent;
import org.openl.ie.constrainer.impl.UndoBits;
import org.openl.ie.constrainer.impl.UndoableBits;

public final class ConstraintElement
extends ConstraintImpl {
    private IntArray _array;
    private IntExp _index_exp;
    private IntVar _element;
    private UndoableBits _bits;

    public ConstraintElement(IntArray values, IntExp index_exp, IntVar element_var) {
        super(values.constrainer(), "ConstraintElement");
        this._index_exp = index_exp;
        this._array = values;
        this._element = element_var;
        int size = values.size();
        this._bits = new UndoableBits(values.constrainer(), 0, size - 1);
        this._bits.object(this);
    }

    public Goal execute() throws Failure {
        int size = this._array.size();
        for (int i = 0; i < size; ++i) {
            if (this._index_exp.contains(i)) continue;
            this.removeFromIndex(i);
        }
        this._element.attachObserver(new ObserverForElement());
        this._index_exp.attachObserver(new ObserverForIndex());
        return null;
    }

    void removeFromElement(int value) throws Failure {
        for (int i = this._index_exp.min(); i <= this._index_exp.min(); ++i) {
            if (this._array.get(i) != value) continue;
            this._index_exp.removeValue(i);
            if (this._bits.bit(i)) continue;
            this._bits.bit(i, true);
            this.constrainer().addUndo(UndoBits.getUndo(this._bits, i));
        }
    }

    void removeFromIndex(int index) throws Failure {
        if (!this._bits.bit(index)) {
            int removed_value = this._array.get(index);
            this._bits.bit(index, true);
            this.constrainer().addUndo(UndoBits.getUndo(this._bits, index));
            int[] data = this._array.data();
            for (int i = 0; i < data.length; ++i) {
                if (data[i] != removed_value || this._bits.bit(i)) continue;
                return;
            }
            this._element.removeValue(removed_value);
        }
    }

    public String toString() {
        return "ConstraintElement: " + this._element + "=array[" + this._index_exp + "]";
    }

    class ObserverForIndex
    extends Observer {
        ObserverForIndex() {
        }

        public Object master() {
            return ConstraintElement.this;
        }

        public int subscriberMask() {
            return 15;
        }

        public String toString() {
            return "ObserverForIndex";
        }

        public void update(Subject var, EventOfInterest interest) throws Failure {
            block5: {
                IntEvent e;
                block7: {
                    block6: {
                        block4: {
                            e = (IntEvent)interest;
                            if (!e.isValueEvent()) break block4;
                            int index = e.min();
                            for (int i = e.oldmin(); i <= e.oldmax(); ++i) {
                                if (i == index) continue;
                                ConstraintElement.this._bits.bit(i, true);
                                ConstraintElement.this.constrainer().addUndo(UndoBits.getUndo(ConstraintElement.this._bits, i));
                            }
                            ConstraintElement.this._element.setValue(ConstraintElement.this._array.get(index));
                            break block5;
                        }
                        if (!e.isRemoveEvent()) break block6;
                        for (int i = 0; i < e.numberOfRemoves(); ++i) {
                            int removed_index = e.removed(i);
                            ConstraintElement.this.removeFromIndex(removed_index);
                        }
                        break block5;
                    }
                    if (!e.isMinEvent()) break block7;
                    for (int i = e.oldmin(); i < e.min(); ++i) {
                        ConstraintElement.this.removeFromIndex(i);
                    }
                    break block5;
                }
                if (!e.isMaxEvent()) break block5;
                for (int i = e.oldmax(); i > e.max(); --i) {
                    ConstraintElement.this.removeFromIndex(i);
                }
            }
        }
    }

    class ObserverForElement
    extends Observer {
        ObserverForElement() {
        }

        public Object master() {
            return ConstraintElement.this;
        }

        public int subscriberMask() {
            return 15;
        }

        public String toString() {
            return "ObserverForElement";
        }

        public void update(Subject var, EventOfInterest interest) throws Failure {
            block5: {
                IntEvent e;
                block7: {
                    block6: {
                        block4: {
                            e = (IntEvent)interest;
                            if (!e.isValueEvent()) break block4;
                            int value = e.min();
                            for (int i = ConstraintElement.this._index_exp.min(); i <= ConstraintElement.this._index_exp.max(); ++i) {
                                if (ConstraintElement.this._array.get(i) == value) continue;
                                ConstraintElement.this._index_exp.removeValue(i);
                                if (ConstraintElement.this._bits.bit(i)) continue;
                                ConstraintElement.this._bits.bit(i, true);
                                ConstraintElement.this.constrainer().addUndo(UndoBits.getUndo(ConstraintElement.this._bits, i));
                            }
                            break block5;
                        }
                        if (!e.isRemoveEvent()) break block6;
                        for (int i = 0; i < e.numberOfRemoves(); ++i) {
                            int removed_value = e.removed(i);
                            ConstraintElement.this.removeFromElement(removed_value);
                        }
                        break block5;
                    }
                    if (!e.isMinEvent()) break block7;
                    for (int i = ConstraintElement.this._index_exp.min(); i < e.min(); ++i) {
                        ConstraintElement.this._index_exp.removeValue(i);
                        if (ConstraintElement.this._bits.bit(i)) continue;
                        ConstraintElement.this._bits.bit(i, true);
                        ConstraintElement.this.constrainer().addUndo(UndoBits.getUndo(ConstraintElement.this._bits, i));
                    }
                    break block5;
                }
                if (!e.isMaxEvent()) break block5;
                for (int i = ConstraintElement.this._index_exp.max(); i > e.max(); --i) {
                    ConstraintElement.this._index_exp.removeValue(i);
                    if (ConstraintElement.this._bits.bit(i)) continue;
                    ConstraintElement.this._bits.bit(i, true);
                    ConstraintElement.this.constrainer().addUndo(UndoBits.getUndo(ConstraintElement.this._bits, i));
                }
            }
        }
    }
}

