/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.ConstraintImpl;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ConstraintExpLessValue;
import org.openl.ie.constrainer.impl.IntEvent;

public final class ConstraintExpMoreValue
extends ConstraintImpl {
    private IntExp _exp;
    private int _value;
    private Constraint _opposite;

    public ConstraintExpMoreValue(IntExp exp, int value) {
        super(exp.constrainer());
        if (this.constrainer().showInternalNames()) {
            this._name = "(" + exp.name() + ">" + value + ")";
        }
        this._exp = exp;
        this._value = value;
        this._opposite = null;
    }

    public Goal execute() throws Failure {
        this._exp.setMin(this._value + 1);
        this._exp.attachObserver(new ObserverMoreValue());
        return null;
    }

    public boolean isLinear() {
        return this._exp.isLinear();
    }

    public Constraint opposite() {
        if (this._opposite == null) {
            this._opposite = new ConstraintExpLessValue(this._exp, this._value + 1);
        }
        return this._opposite;
    }

    public IntBoolExp toIntBoolExp() {
        return this._exp.gt(this._value);
    }

    public String toString() {
        return this._exp + ">" + this._value;
    }

    class ObserverMoreValue
    extends Observer {
        ObserverMoreValue() {
        }

        public Object master() {
            return ConstraintExpMoreValue.this;
        }

        public int subscriberMask() {
            return 5;
        }

        public String toString() {
            return "ObserverMoreValue";
        }

        public void update(Subject exp, EventOfInterest interest) throws Failure {
            IntEvent event = (IntEvent)interest;
            if (event.max() <= ConstraintExpMoreValue.this._value) {
                exp.constrainer().fail("from ObserverMoreValue");
            }
            ConstraintExpMoreValue.this._exp.setMin(ConstraintExpMoreValue.this._value + 1);
        }
    }
}

