/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.ConstraintImpl;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ConstraintExpEqualsValue;
import org.openl.ie.constrainer.impl.IntEvent;

public final class ConstraintExpNotValue
extends ConstraintImpl {
    private IntExp _exp;
    private int _value;
    private Constraint _opposite;

    public ConstraintExpNotValue(IntExp exp, int value) {
        super(exp.constrainer());
        if (this.constrainer().showInternalNames()) {
            this._name = "(" + exp.name() + "!=" + value + ")";
        }
        this._exp = exp;
        this._value = value;
    }

    public Goal execute() throws Failure {
        if (this._value == this._exp.max()) {
            this._exp.setMax(this._value - 1);
        } else if (this._value == this._exp.min()) {
            this._exp.setMin(this._value + 1);
        } else {
            class ObserverExpNotValue
            extends Observer {
                ObserverExpNotValue() {
                }

                public Object master() {
                    return ConstraintExpNotValue.this;
                }

                public int subscriberMask() {
                    return 1;
                }

                public String toString() {
                    return "ObserverExpNotValue:" + ConstraintExpNotValue.this._exp.name() + "!=" + ConstraintExpNotValue.this._value;
                }

                public void update(Subject exp, EventOfInterest interest) throws Failure {
                    int value = ((IntEvent)interest).min();
                    if (value == ConstraintExpNotValue.this._value) {
                        ConstraintExpNotValue.this.constrainer().fail();
                    }
                }
            }
            this._exp.attachObserver(new ObserverExpNotValue());
        }
        return null;
    }

    public Constraint opposite() {
        if (this._opposite == null) {
            this._opposite = new ConstraintExpEqualsValue(this._exp, this._value);
        }
        return this._opposite;
    }

    public IntBoolExp toIntBoolExp() {
        return this._exp.ne(this._value);
    }

    public String toString() {
        return this._exp + "!=" + this._value;
    }
}

