/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.ConstraintImpl;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatEvent;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ConstraintFloatExpEqualsValue;
import org.openl.ie.constrainer.impl.FloatCalc;

public final class ConstraintFloatExpNotValue
extends ConstraintImpl {
    private FloatExp _exp;
    private double _value;
    private Constraint _opposite;

    public ConstraintFloatExpNotValue(FloatExp exp, double value) {
        super(exp.constrainer(), "");
        this._exp = exp;
        this._value = value;
    }

    public Goal execute() throws Failure {
        class ObserverFloatExpNotValue
        extends Observer {
            ObserverFloatExpNotValue() {
            }

            public Object master() {
                return ConstraintFloatExpNotValue.this;
            }

            public int subscriberMask() {
                return 1;
            }

            public String toString() {
                return "ObserverFloatExpNotValue:" + ConstraintFloatExpNotValue.this._exp.name() + "!=" + ConstraintFloatExpNotValue.this._value;
            }

            public void update(Subject exp, EventOfInterest interest) throws Failure {
                FloatEvent event = (FloatEvent)interest;
                double value = (event.min() + event.max()) / 2.0;
                if (FloatCalc.eq(value, ConstraintFloatExpNotValue.this._value)) {
                    ConstraintFloatExpNotValue.this.constrainer().fail("attempt to set a removed value " + value + " for " + exp);
                }
            }
        }
        this._exp.attachObserver(new ObserverFloatExpNotValue());
        return null;
    }

    public Constraint opposite() {
        if (this._opposite == null) {
            this._opposite = new ConstraintFloatExpEqualsValue(this._exp, this._value);
        }
        return this._opposite;
    }

    public IntBoolExp toIntBoolExp() {
        return this._exp.ne(this._value);
    }

    public String toString() {
        return this._exp + "!=" + this._value;
    }
}

