/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.impl.DomainImpl;
import org.openl.ie.constrainer.impl.DomainInterval;
import org.openl.ie.tools.FastVector;

public final class DomainImplWithHoles
extends DomainImpl {
    private FastVector _values = new FastVector();

    public DomainImplWithHoles(IntVar var, int min, int max) {
        super(var, min, max);
        this._values.addElement(new DomainInterval(min, max));
    }

    public boolean contains(int value) {
        if (value < this._min || value > this._max) {
            return false;
        }
        for (int i = 0; i < this._values.size(); ++i) {
            DomainInterval interval = (DomainInterval)this._values.elementAt(i);
            if (value < interval.from || value > interval.to) continue;
            return true;
        }
        return false;
    }

    public void force(FastVector values) {
        this._values = values;
        DomainInterval first = (DomainInterval)this._values.firstElement();
        this._min = first.from;
        DomainInterval last = (DomainInterval)this._values.lastElement();
        this._max = last.to;
    }

    public void forceMax(int max) {
        this._max = max;
    }

    public void forceMin(int min) {
        this._min = min;
    }

    public int max() {
        return this._max;
    }

    public int min() {
        return this._min;
    }

    public boolean removeValue(int value) throws Failure {
        if (value == this._min) {
            return this.setMin(value + 1);
        }
        if (value == this._max) {
            return this.setMax(value - 1);
        }
        this._variable.addUndo();
        for (int i = 0; i < this._values.size(); ++i) {
            DomainInterval interval = (DomainInterval)this._values.elementAt(i);
            if (value < interval.from || value > interval.to) continue;
            if (interval.from == interval.to) {
                if (this._values.size() == 1) {
                    this.constrainer().fail("remove");
                }
                this._values.removeElementAt(i);
            } else if (value == interval.from) {
                ++interval.from;
            } else if (value == interval.to) {
                --interval.to;
            } else {
                int from1 = interval.from;
                int to1 = value - 1;
                int from2 = value + 1;
                int to2 = interval.to;
                interval.to = to1;
                this._values.insertElementAt(new DomainInterval(from2, to2), i + 1);
            }
            return true;
        }
        return false;
    }

    public boolean setMax(int M) throws Failure {
        DomainInterval interval;
        if (M >= this._max) {
            return false;
        }
        if (M < this._min) {
            this.constrainer().fail("Max < Min for " + this._variable);
        }
        this._variable.addUndo();
        while (!this._values.isEmpty()) {
            interval = (DomainInterval)this._values.lastElement();
            if (M < interval.from) {
                this._values.removeLast();
                continue;
            }
            if (M >= interval.to) break;
            interval.to = M;
            break;
        }
        interval = (DomainInterval)this._values.lastElement();
        this._max = interval.to;
        return true;
    }

    public boolean setMin(int m) throws Failure {
        DomainInterval interval;
        if (m <= this.min()) {
            return false;
        }
        if (m > this.max()) {
            this.constrainer().fail("Min > Max for " + this._variable);
        }
        this._variable.addUndo();
        while (!this._values.isEmpty()) {
            interval = (DomainInterval)this._values.firstElement();
            if (m > interval.to) {
                this._values.removeElementAt(0);
                continue;
            }
            if (m <= interval.from) break;
            interval.from = m;
            break;
        }
        interval = (DomainInterval)this._values.firstElement();
        this._min = interval.from;
        return true;
    }

    public boolean setValue(int value) throws Failure {
        if (this._min == value && this._max == value) {
            return false;
        }
        if (!this.contains(value)) {
            this.constrainer().fail("attempt to set invalid value for " + this._variable);
        }
        this._variable.addUndo();
        this._values.clear();
        this._values.addElement(new DomainInterval(value, value));
        this._min = value;
        this._max = value;
        return true;
    }

    public int size() {
        int s = 0;
        for (int i = 0; i < this._values.size(); ++i) {
            DomainInterval interval = (DomainInterval)this._values.elementAt(i);
            s += interval.to - interval.from + 1;
        }
        return s;
    }

    public String toString() {
        return this._values.toString();
    }

    FastVector values() {
        return this._values;
    }
}

