/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatExp;

public final class FloatCalc {
    public static final double NaN = Double.NaN;
    public static final double pInf = Double.POSITIVE_INFINITY;
    public static final double nInf = Double.NEGATIVE_INFINITY;

    public static void assertMinMax(double min, double max) {
        FloatCalc.doAssert(!FloatCalc.isNan(min), "min not NaN");
        FloatCalc.doAssert(!FloatCalc.isNan(max), "max not NaN");
        FloatCalc.doAssert(min <= max, "min <= max");
    }

    public static double calc_log(double x, double base) {
        return Math.log(x) / Math.log(base);
    }

    public static void doAssert(boolean v, String s) {
        if (v) {
            return;
        }
        System.out.println("Assertion failed: " + s);
    }

    public static boolean eq(double d1, double d2) {
        return Math.abs(d1 - d2) < Constrainer.FLOAT_PRECISION;
    }

    public static boolean ge(double d1, double d2) {
        return d1 - d2 > -Constrainer.FLOAT_PRECISION;
    }

    public static boolean gt(double d1, double d2) {
        return d1 - d2 > Constrainer.FLOAT_PRECISION;
    }

    public static double inverseMax(double v) {
        return v != 0.0 ? 1.0 / v : Double.POSITIVE_INFINITY;
    }

    public static double inverseMax(double min, double max) {
        FloatCalc.assertMinMax(min, max);
        double _max = min > 0.0 || max < 0.0 ? 1.0 / min : (min == 0.0 && max > 0.0 ? Double.POSITIVE_INFINITY : (max == 0.0 && min < 0.0 ? 1.0 / min : Double.POSITIVE_INFINITY));
        return _max;
    }

    public static double inverseMin(double v) {
        return v != 0.0 ? 1.0 / v : Double.NEGATIVE_INFINITY;
    }

    public static double inverseMin(double min, double max) {
        FloatCalc.assertMinMax(min, max);
        double _min = min > 0.0 || max < 0.0 ? 1.0 / max : (min == 0.0 && max > 0.0 ? 1.0 / max : (max == 0.0 && min < 0.0 ? Double.NEGATIVE_INFINITY : Double.NEGATIVE_INFINITY));
        return _min;
    }

    public static boolean isInf(double v) {
        return Double.isInfinite(v);
    }

    public static boolean isNan(double v) {
        return Double.isNaN(v);
    }

    public static double productMax(double min1, double max1, double min2, double max2) {
        if (min1 >= 0.0) {
            return FloatCalc.productMaxP(min1, max1, max2);
        }
        if (max1 <= 0.0) {
            return FloatCalc.productMaxN(min1, max1, min2);
        }
        if (min2 >= 0.0) {
            return max1 * max2;
        }
        if (max2 <= 0.0) {
            return min1 * min2;
        }
        return Math.max(min1 * min2, max1 * max2);
    }

    public static double productMaxN(double min1, double max1, double min2) {
        if (min2 >= 0.0) {
            return max1 * min2;
        }
        return min1 * min2;
    }

    public static double productMaxP(double min1, double max1, double max2) {
        if (max2 >= 0.0) {
            return max1 * max2;
        }
        return min1 * max2;
    }

    public static double productMin(double min1, double max1, double min2, double max2) {
        if (min1 >= 0.0) {
            return FloatCalc.productMinP(min1, max1, min2);
        }
        if (max1 <= 0.0) {
            return FloatCalc.productMinN(min1, max1, max2);
        }
        if (min2 >= 0.0) {
            return min1 * max2;
        }
        if (max2 <= 0.0) {
            return max1 * min2;
        }
        return Math.min(max1 * min2, min1 * max2);
    }

    public static double productMinN(double min1, double max1, double max2) {
        if (max2 >= 0.0) {
            return min1 * max2;
        }
        return max1 * max2;
    }

    public static double productMinP(double min1, double max1, double min2) {
        if (min2 >= 0.0) {
            return min1 * min2;
        }
        return max1 * min2;
    }

    public static void productSetMax(double max, FloatExp exp1, FloatExp exp2) throws Failure {
        double d;
        double min1 = exp1.min();
        if (d >= 0.0) {
            FloatCalc.productSetMaxP(max, min1, exp1.max(), exp2);
        } else {
            double d2;
            double max1 = exp1.max();
            if (d2 <= 0.0) {
                FloatCalc.productSetMaxN(max, min1, max1, exp2);
            } else if (max < 0.0) {
                double m = max1 / max;
                double M = min1 / max;
                exp2.removeRange(m, M);
            }
        }
    }

    public static void productSetMaxN(double max, double min1, double max1, FloatExp exp2) throws Failure {
        if (max == 0.0) {
            if (max1 < 0.0) {
                exp2.setMin(0.0);
            }
        } else {
            double v;
            double d = v = max > 0.0 ? max1 : min1;
            if (v != 0.0) {
                double min2 = max / v;
                exp2.setMin(min2);
            }
        }
    }

    public static void productSetMaxP(double max, double min1, double max1, FloatExp exp2) throws Failure {
        if (max == 0.0) {
            if (min1 > 0.0) {
                exp2.setMax(0.0);
            }
        } else {
            double v;
            double d = v = max > 0.0 ? min1 : max1;
            if (v != 0.0) {
                double max2 = max / v;
                exp2.setMax(max2);
            }
        }
    }

    public static void productSetMin(double min, FloatExp exp1, FloatExp exp2) throws Failure {
        double d;
        double min1 = exp1.min();
        if (d >= 0.0) {
            FloatCalc.productSetMinP(min, min1, exp1.max(), exp2);
        } else {
            double d2;
            double max1 = exp1.max();
            if (d2 <= 0.0) {
                FloatCalc.productSetMinN(min, min1, max1, exp2);
            } else if (min > 0.0) {
                double m = min1 / min;
                double M = max1 / min;
                exp2.removeRange(m, M);
            }
        }
    }

    public static void productSetMinN(double min, double min1, double max1, FloatExp exp2) throws Failure {
        if (min == 0.0) {
            if (max1 < 0.0) {
                exp2.setMax(0.0);
            }
        } else {
            double v;
            double d = v = min > 0.0 ? min1 : max1;
            if (v != 0.0) {
                double max2 = min / v;
                exp2.setMax(max2);
            }
        }
    }

    public static void productSetMinP(double min, double min1, double max1, FloatExp exp2) throws Failure {
        if (min == 0.0) {
            if (min1 > 0.0) {
                exp2.setMin(0.0);
            }
        } else {
            double v;
            double d = v = min > 0.0 ? max1 : min1;
            if (v != 0.0) {
                double min2 = min / v;
                exp2.setMin(min2);
            }
        }
    }

    public static double solve_pow(double y, double v) {
        double x = Math.pow(y, 1.0 / v);
        return x;
    }

    public static double sqrMax(double min, double max) {
        return Math.max(min * min, max * max);
    }

    public static double sqrMin(double min, double max) {
        if (min >= 0.0) {
            return min * min;
        }
        if (max >= 0.0) {
            return 0.0;
        }
        return max * max;
    }
}

