/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatEvent;
import org.openl.ie.constrainer.FloatVar;
import org.openl.ie.tools.FastVectorDouble;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public final class FloatDomainHistory {
    static final int MIN_IDX = 0;
    static final int MAX_IDX = 1;
    static final int LAST_IDX = 2;
    FloatVar _var;
    double _min;
    double _max;
    int _mask;
    FastVectorDouble _history;
    int _currentIndex = -1;

    public FloatDomainHistory(FloatVar var) {
        this._var = var;
        this._history = new FastVectorDouble(10);
        this.save();
    }

    public int currentIndex() {
        return this._currentIndex;
    }

    public double max() {
        return this._max;
    }

    public double min() {
        return this._min;
    }

    public double oldmax() {
        return this._history.elementAt(this._currentIndex + 1);
    }

    public double oldmin() {
        return this._history.elementAt(this._currentIndex + 0);
    }

    void propagate() throws Failure {
        if ((this._var.publisherMask() & this._mask) != 0) {
            FloatEventDomain ev = FloatEventDomain.getEvent(this);
            this.save();
            this._var.notifyObservers(ev);
        } else {
            this.save();
        }
    }

    public void restore(int index) {
        this._min = this._history.elementAt(index + 0);
        this._var.forceMin(this._min);
        this._max = this._history.elementAt(index + 1);
        this._var.forceMax(this._max);
        this._history.cutSize(index + 2);
        this._currentIndex = index;
        this._mask = 0;
    }

    int save() {
        int old = this._currentIndex;
        this._currentIndex = this._history.size();
        this._min = this._var.min();
        this._history.add(this._min);
        this._max = this._var.max();
        this._history.add(this._max);
        this._mask = 0;
        return old;
    }

    public void saveUndo() {
        if (this._mask != 0) {
            this.save();
        }
    }

    void setMax(double val) {
        if (val < this._max - Constrainer.FLOAT_PRECISION) {
            this._max = val;
            this._mask |= 4;
            if (this._var.bound()) {
                this._mask |= 1;
            }
        }
    }

    void setMin(double val) {
        if (val > this._min + Constrainer.FLOAT_PRECISION) {
            this._min = val;
            this._mask |= 2;
            if (this._var.bound()) {
                this._mask |= 1;
            }
        }
    }

    public String toString() {
        return "History: " + this._history + ":" + this._currentIndex + "(" + this._min + "-" + this._max + ")" + "mask: " + this._mask;
    }

    static final class FloatEventDomain
    extends FloatEvent {
        static ReusableFactory _factory = new ReusableFactory(){

            protected Reusable createNewElement() {
                return new FloatEventDomain();
            }
        };
        protected double _min;
        protected double _max;
        protected double _oldmin;
        protected double _oldmax;
        protected int _type_mask;
        FloatDomainHistory _history;

        FloatEventDomain() {
        }

        static FloatEventDomain getEvent(FloatDomainHistory history) {
            FloatEventDomain ev = (FloatEventDomain)_factory.getElement();
            ev.init(history);
            return ev;
        }

        public void init(FloatDomainHistory hist) {
            this.exp(hist._var);
            this._min = hist.min();
            this._max = hist.max();
            this._oldmin = hist.oldmin();
            this._oldmax = hist.oldmax();
            this._type_mask = hist._mask;
            this._history = hist;
        }

        public double max() {
            return this._max;
        }

        public double maxdiff() {
            return this._max - this._oldmax;
        }

        public double min() {
            return this._min;
        }

        public double mindiff() {
            return this._min - this._oldmin;
        }

        public String name() {
            return "FloatEventDomain";
        }

        public double oldmax() {
            return this._oldmax;
        }

        public double oldmin() {
            return this._oldmin;
        }

        public int type() {
            return this._type_mask;
        }
    }
}

