/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatDomain;
import org.openl.ie.constrainer.FloatVar;

public class FloatDomainImpl
implements FloatDomain {
    private FloatVar _variable;
    private double _initial_min;
    private double _initial_max;
    private double _min;
    private double _max;

    public FloatDomainImpl(FloatVar var, double min, double max) {
        this._variable = var;
        this._initial_min = min;
        this._initial_max = max;
        this._min = min;
        this._max = max;
    }

    public Constrainer constrainer() {
        return this._variable.constrainer();
    }

    public boolean contains(double value) {
        return !(value < this._min - Constrainer.FLOAT_PRECISION) && !(value > this._max + Constrainer.FLOAT_PRECISION);
    }

    public void forceMax(double M) {
        this._max = M;
    }

    public void forceMin(double m) {
        this._min = m;
    }

    public double max() {
        return this._max;
    }

    public double min() {
        return this._min;
    }

    public boolean setMax(double M) throws Failure {
        if (M > this._max) {
            return false;
        }
        if (M < this._min - Constrainer.FLOAT_PRECISION) {
            this.constrainer().fail("FloatDomainImpl setMax");
        }
        this._variable.addUndo();
        this._max = M;
        return true;
    }

    public boolean setMin(double m) throws Failure {
        if (m < this._min) {
            return false;
        }
        if (m > this._max + Constrainer.FLOAT_PRECISION) {
            this.constrainer().fail("FloatDomainImpl setMin");
        }
        this._variable.addUndo();
        this._min = m;
        return true;
    }

    public boolean setValue(double value) throws Failure {
        if (!this.contains(value)) {
            this.constrainer().fail("attempt to set invalid value for " + this._variable);
        }
        if (Math.abs(this._max - this._min) < Constrainer.FLOAT_PRECISION) {
            return false;
        }
        this._variable.addUndo();
        this._min = value;
        this._max = value;
        return true;
    }

    public double size() {
        return this._max - this._min;
    }

    public String toString() {
        return "[" + this._min + ".." + this._max + (this._variable.bound() ? "(" + (this._min + this._max) / 2.0 + ")" : "") + "]";
    }

    public void variable(FloatVar var) {
        this._variable = var;
    }
}

