/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.FloatExpArray;
import org.openl.ie.constrainer.FloatVar;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.FloatExpImpl;

public final class FloatExpAddArray
extends FloatExpImpl {
    private static final int[] event_map = new int[]{2, 2, 4, 4, 7, 1};
    private FloatExpArray _vars;
    private Observer _observer;
    private FloatVar _sum;

    public FloatExpAddArray(Constrainer constrainer, FloatExpArray vars) {
        super(constrainer, "");
        this._vars = vars;
        this._observer = new FloatExpAddVectorObserver();
        FloatExp[] data = this._vars.data();
        for (int i = 0; i < data.length; ++i) {
            data[i].attachObserver(this._observer);
        }
        String sum_name = "";
        if (this.constrainer().showInternalNames()) {
            StringBuffer s = new StringBuffer();
            s.append("(");
            for (int i = 0; i < data.length; ++i) {
                if (i != 0) {
                    s.append("+");
                }
                s.append(data[i].name());
            }
            s.append(")");
            this._name = s.toString();
            sum_name = "sum(" + this._vars.name() + ")";
        }
        int trace = 0;
        double min = this.calc_min();
        double max = this.calc_max();
        this._sum = this.constrainer().addFloatVarTraceInternal(min, max, sum_name, trace);
    }

    public void attachObserver(Observer observer) {
        super.attachObserver(observer);
        this._sum.attachObserver(observer);
    }

    public double calc_max() {
        double max_sum = 0.0;
        FloatExp[] vars = this._vars.data();
        for (int i = 0; i < vars.length; ++i) {
            max_sum += vars[i].max();
        }
        return max_sum;
    }

    double calc_min() {
        double min_sum = 0.0;
        FloatExp[] vars = this._vars.data();
        for (int i = 0; i < vars.length; ++i) {
            min_sum += vars[i].min();
        }
        return min_sum;
    }

    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        if (!this.isLinear()) {
            throw new NonLinearExpression(this);
        }
        double cumSum = 0.0;
        for (int i = 0; i < this._vars.size(); ++i) {
            cumSum += this._vars.get(i).calcCoeffs(map, factor);
        }
        return cumSum;
    }

    public void detachObserver(Observer observer) {
        super.detachObserver(observer);
        this._sum.detachObserver(observer);
    }

    public boolean isLinear() {
        for (int i = 0; i < this._vars.size(); ++i) {
            if (this._vars.get(i).isLinear()) continue;
            return false;
        }
        return true;
    }

    public double max() {
        return this._sum.max();
    }

    public double min() {
        return this._sum.min();
    }

    public void name(String name) {
        super.name(name);
        this._sum.name(name);
    }

    public void onMaskChange() {
    }

    public void reattachObserver(Observer observer) {
        super.reattachObserver(observer);
        this._sum.reattachObserver(observer);
    }

    public void setMax(double max) throws Failure {
        if (max >= this.max()) {
            return;
        }
        double min_sum = this.min();
        FloatExp[] vars = this._vars.data();
        for (int i = 0; i < vars.length; ++i) {
            FloatExp vari = vars[i];
            double maxi = max - (min_sum - vari.min());
            if (!(maxi < vari.max())) continue;
            vari.setMax(maxi);
        }
    }

    public void setMin(double min) throws Failure {
        if (min <= this.min()) {
            return;
        }
        double max_sum = this.max();
        FloatExp[] vars = this._vars.data();
        for (int i = 0; i < vars.length; ++i) {
            FloatExp vari = vars[i];
            double mini = min - (max_sum - vari.max());
            if (!(mini > vari.min())) continue;
            vari.setMin(mini);
        }
    }

    public void setValue(double value) throws Failure {
        double sum_min = this.min();
        double sum_max = this.max();
        if (value < sum_min || value > sum_max) {
            this._constrainer.fail("Float Add Array Set Value");
        }
        if (value == sum_min) {
            this.setMax(value);
            return;
        }
        if (value == sum_max) {
            this.setMin(value);
            return;
        }
        FloatExp[] vars = this._vars.data();
        for (int i = 0; i < vars.length; ++i) {
            double new_max;
            FloatExp vari = vars[i];
            double mini = vari.min();
            double maxi = vari.max();
            double new_min = value - (sum_max - maxi);
            if (new_min > mini) {
                vari.setMin(new_min);
            }
            if (!((new_max = value - (sum_min - mini)) < maxi)) continue;
            vari.setMax(new_max);
        }
    }

    class FloatExpAddVectorObserver
    extends Observer {
        FloatExpAddVectorObserver() {
        }

        public Object master() {
            return FloatExpAddArray.this;
        }

        public int subscriberMask() {
            return 7;
        }

        public String toString() {
            return "FloatExpAddVectorObserver: " + FloatExpAddArray.this._vars;
        }

        public void update(Subject exp, EventOfInterest event) throws Failure {
            FloatExpAddArray.this._sum.setMin(FloatExpAddArray.this.calc_min());
            FloatExpAddArray.this._sum.setMax(FloatExpAddArray.this.calc_max());
        }
    }
}

