/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.FloatVar;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.FloatExpImpl;

public final class FloatExpAddExp
extends FloatExpImpl {
    private FloatExp _exp1;
    private FloatExp _exp2;
    private Observer _observer;
    private FloatVar _sum;

    public FloatExpAddExp(FloatExp exp1, FloatExp exp2) {
        super(exp1.constrainer(), "");
        this._exp1 = exp1;
        this._exp2 = exp2;
        int trace = 0;
        this._sum = this.constrainer().addFloatVarTraceInternal(this.calc_min(), this.calc_max(), "sum", trace);
        this._observer = new ExpAddExpObserver();
        this._exp1.attachObserver(this._observer);
        this._exp2.attachObserver(this._observer);
    }

    public void attachObserver(Observer observer) {
        super.attachObserver(observer);
        this._sum.attachObserver(observer);
    }

    public double calc_max() {
        return this._exp1.max() + this._exp2.max();
    }

    public double calc_min() {
        return this._exp1.min() + this._exp2.min();
    }

    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        return this._exp1.calcCoeffs(map, factor) + this._exp2.calcCoeffs(map, factor);
    }

    public void detachObserver(Observer observer) {
        super.detachObserver(observer);
        this._sum.detachObserver(observer);
    }

    public boolean isLinear() {
        return this._exp1.isLinear() && this._exp2.isLinear();
    }

    public double max() {
        return this._sum.max();
    }

    public double min() {
        return this._sum.min();
    }

    public void reattachObserver(Observer observer) {
        super.reattachObserver(observer);
        this._sum.reattachObserver(observer);
    }

    public void setMax(double max) throws Failure {
        double max2;
        if (max >= this._sum.max()) {
            return;
        }
        double max1 = max - this._exp2.min();
        if (max1 < this._exp1.max()) {
            this._exp1.setMax(max1);
        }
        if ((max2 = max - this._exp1.min()) < this._exp2.max()) {
            this._exp2.setMax(max2);
        }
    }

    public void setMin(double min) throws Failure {
        double min2;
        if (min <= this._sum.min()) {
            return;
        }
        double min1 = min - this._exp2.max();
        if (min1 > this._exp1.min()) {
            this._exp1.setMin(min1);
        }
        if ((min2 = min - this._exp1.max()) > this._exp2.min()) {
            this._exp2.setMin(min2);
        }
    }

    public void setValue(double value) throws Failure {
        this.setMin(value);
        this.setMax(value);
    }

    class ExpAddExpObserver
    extends Observer {
        ExpAddExpObserver() {
        }

        public Object master() {
            return FloatExpAddExp.this;
        }

        public int subscriberMask() {
            return 7;
        }

        public String toString() {
            return "ExpAddExpObserver: ";
        }

        public void update(Subject exp, EventOfInterest event) throws Failure {
            FloatExpAddExp.this._sum.setMin(FloatExpAddExp.this.calc_min());
            FloatExpAddExp.this._sum.setMax(FloatExpAddExp.this.calc_max());
        }
    }
}

