/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatEvent;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ExpressionObserver;
import org.openl.ie.constrainer.impl.FloatExpImpl;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public final class FloatExpOpposite
extends FloatExpImpl {
    private static final int[] event_map = new int[]{2, 4, 4, 2, 1, 1, 8, 8};
    private FloatExp _exp;
    private ExpressionObserver _observer;

    public FloatExpOpposite(FloatExp exp) {
        super(exp.constrainer(), "");
        this._exp = exp;
        this._observer = new FloatExpOppositeObserver();
        this._exp.attachObserver(this._observer);
    }

    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        return this._exp.calcCoeffs(map, -1.0 * factor);
    }

    public boolean isLinear() {
        return this._exp.isLinear();
    }

    public double max() {
        return -this._exp.min();
    }

    public double min() {
        return -this._exp.max();
    }

    public FloatExp negF() {
        return this._exp;
    }

    public void onMaskChange() {
        this._observer.publish(this.publisherMask(), this._exp);
    }

    public void setMax(double max) throws Failure {
        this._exp.setMin(-max);
    }

    public void setMin(double min) throws Failure {
        this._exp.setMax(-min);
    }

    public void setValue(double value) throws Failure {
        this._exp.setValue(-value);
    }

    public String toString() {
        return "-" + this._exp + this.domainToString();
    }

    class FloatExpOppositeObserver
    extends ExpressionObserver {
        FloatExpOppositeObserver() {
            super(event_map);
        }

        public Object master() {
            return FloatExpOpposite.this;
        }

        public String toString() {
            return "FloatExpOppositeObserver: " + FloatExpOpposite.this._exp;
        }

        public void update(Subject exp, EventOfInterest event) throws Failure {
            FloatEvent e = (FloatEvent)event;
            FloatEventOpposite ev = FloatEventOpposite.getEvent(e);
            ev.exp(FloatExpOpposite.this);
            FloatExpOpposite.this.notifyObservers(ev);
        }
    }

    static class FloatEventOpposite
    extends FloatEvent {
        static ReusableFactory _factory = new ReusableFactory(){

            protected Reusable createNewElement() {
                return new FloatEventOpposite();
            }
        };
        FloatEvent _event;
        int _type;

        FloatEventOpposite() {
        }

        static FloatEventOpposite getEvent(FloatEvent event) {
            FloatEventOpposite ev = (FloatEventOpposite)_factory.getElement();
            ev.init(event);
            return ev;
        }

        public void init(FloatEvent e) {
            int type;
            this._event = e;
            this._type = type = e.type();
            this._type |= 6;
            if ((type & 2) == 0) {
                this._type &= 0xFFFFFFFB;
            }
            if ((type & 4) == 0) {
                this._type &= 0xFFFFFFFD;
            }
        }

        public double max() {
            return -this._event.min();
        }

        public double min() {
            return -this._event.max();
        }

        public String name() {
            return "FloatEventOpposite";
        }

        public double oldmax() {
            return -this._event.oldmin();
        }

        public double oldmin() {
            return -this._event.oldmax();
        }

        public int type() {
            return this._type;
        }
    }
}

